/*
 * Decompiled with CFR 0.152.
 */
package com.boingboing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class BounceConfigFabric {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("boingboingitem.json");
    public static double bounceFactor = 0.85;
    public static double minBounceVelocity = 0.08;
    public static double horizontalConservation = 0.98;
    public static double impactThreshold = 0.08;
    public static double soundVolume = 0.5;
    public static int particleCount = 8;
    public static boolean enableSound = true;
    public static boolean enableParticles = true;

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                ConfigData data = (ConfigData)GSON.fromJson(Files.readString(CONFIG_PATH), ConfigData.class);
                bounceFactor = data.bounceFactor;
                minBounceVelocity = data.minBounceVelocity;
                horizontalConservation = data.horizontalConservation;
                impactThreshold = data.impactThreshold;
                soundVolume = data.soundVolume;
                particleCount = data.particleCount;
                enableSound = data.enableSound;
                enableParticles = data.enableParticles;
            }
            catch (IOException e) {
                BounceConfigFabric.save();
            }
        } else {
            BounceConfigFabric.save();
        }
    }

    public static void save() {
        ConfigData data = new ConfigData();
        data.bounceFactor = bounceFactor;
        data.minBounceVelocity = minBounceVelocity;
        data.horizontalConservation = horizontalConservation;
        data.impactThreshold = impactThreshold;
        data.soundVolume = soundVolume;
        data.particleCount = particleCount;
        data.enableSound = enableSound;
        data.enableParticles = enableParticles;
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ConfigData {
        double bounceFactor = 0.85;
        double minBounceVelocity = 0.08;
        double horizontalConservation = 0.98;
        double impactThreshold = 0.08;
        double soundVolume = 0.5;
        int particleCount = 8;
        boolean enableSound = true;
        boolean enableParticles = true;

        private ConfigData() {
        }
    }
}

