/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="simplestationsfarmer", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    static ModConfigSpec SPEC;
    public static ModConfigSpec.IntValue MAX_PROGRESS;
    public static ModConfigSpec.IntValue WATER_PER_CYCLE;
    public static ModConfigSpec.IntValue WATER_MAX;
    public static ModConfigSpec.IntValue FERT_PER_ITEM;
    public static ModConfigSpec.IntValue FERT_MAX;
    public static ModConfigSpec.DoubleValue FERT_MULT;
    public static ModConfigSpec.IntValue POWER_PER_RED;
    public static ModConfigSpec.IntValue POWER_MAX;
    public static ModConfigSpec.DoubleValue POWER_MULT;

    private static void setupGenerationConfig() {
        MAX_PROGRESS = BUILDER.comment("Base working time in ticks\n Default: 24000").defineInRange("work_time", 24000, 1, 100000);
        WATER_PER_CYCLE = BUILDER.comment("How much water to consume per tick\n Default: 1").defineInRange("water_per_cycle", 1, 1, 1000);
        WATER_MAX = BUILDER.comment("Max water to store\n Default: 10000").defineInRange("water_max", 10000, 1, 30000);
        FERT_PER_ITEM = BUILDER.comment("How much fertilizer one item adds\n Default: 3000").defineInRange("fert_per_item", 3000, 1, 10000);
        FERT_MAX = BUILDER.comment("Max fertilizer to store\n Default: 24000").defineInRange("fert_max", 24000, 1, 30000);
        FERT_MULT = BUILDER.comment("Fertilizer productivity multiplier\n Default: +5.0 (i.e. +500%)").defineInRange("fert_mult", 5.0, 0.1, 10.0);
        POWER_PER_RED = BUILDER.comment("How much power one redstone adds\n Default: 1800").defineInRange("power_per_red", 1800, 1, 10000);
        POWER_MAX = BUILDER.comment("Max redstone power to store\n Default: 10000").defineInRange("power_max", 24000, 1, 100000);
        POWER_MULT = BUILDER.comment("Redstone productivity multiplier\n Default: +2.0 (i.e. +200%)").defineInRange("power_mult", 2.0, 0.1, 10.0);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        Config.setupGenerationConfig();
        SPEC = BUILDER.build();
    }
}

