/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.blockentity;

import com.ave.simplestationsfarmer.blockentity.BaseFarmerBlockEntity;
import com.ave.simplestationsfarmer.blockentity.partblock.PartBlockEntity;
import com.ave.simplestationsfarmer.registrations.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredBlock;

public abstract class BaseFarmerBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private final DeferredBlock<Block> block;

    public BaseFarmerBlock(BlockBehaviour.Properties props, DeferredBlock<Block> block) {
        super(props);
        this.block = block;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos, st, be) -> {
            if (be instanceof BaseFarmerBlockEntity) {
                BaseFarmerBlockEntity station = (BaseFarmerBlockEntity)be;
                station.tick();
            }
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BaseFarmerBlockEntity blockEntity = (BaseFarmerBlockEntity)level.getBlockEntity(pos);
        player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity, (Component)Component.literal((String)"")), pos);
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos) || level.getBlockState(p).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        if (level.isClientSide) {
            return;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos)) continue;
                BlockState block = ((Block)ModBlocks.PART.get()).defaultBlockState();
                level.setBlock(p, block, 3);
                PartBlockEntity be = (PartBlockEntity)level.getBlockEntity(p);
                be.setControllerPos(pos);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity controller = level.getBlockEntity(pos);
        if (controller instanceof BaseFarmerBlockEntity) {
            BaseFarmerBlockEntity miner = (BaseFarmerBlockEntity)controller;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack(this.block, 1));
            Containers.dropContents((Level)level, (BlockPos)pos, miner.inventory.getAsList());
        }
        super.onRemove(state, level, pos, newState, moving);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockEntity be;
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos) || !((be = level.getBlockEntity(p)) instanceof PartBlockEntity)) continue;
                level.destroyBlock(p, false);
            }
        }
    }
}

