/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.blockentity;

import com.ave.simplestationsfarmer.Config;
import com.ave.simplestationsfarmer.blockentity.ModContainer;
import com.ave.simplestationsfarmer.blockentity.enums.CropGroup;
import com.ave.simplestationsfarmer.blockentity.enums.CropType;
import com.ave.simplestationsfarmer.blockentity.handlers.WaterTank;
import com.ave.simplestationsfarmer.registrations.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;

public abstract class BaseFarmerBlockEntity
extends ModContainer {
    public EnergyStorage fuel = new EnergyStorage(((Integer)Config.POWER_MAX.get()).intValue());
    public WaterTank tank = WaterTank.create(0);
    public CropType type = CropType.Unknown;
    public float progress = 0.0f;
    public int fertilizer = 0;
    public boolean working = false;
    protected int powerUsage = 1;
    protected int speed = 1;
    public int fluidUsage;
    public int soundCooldown = 0;

    public BaseFarmerBlockEntity(BlockEntityType entity, BlockPos pos, BlockState state, CropGroup group) {
        super((BlockEntityType<BlockEntity>)entity, pos, state, 5, group);
    }

    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.progress >= (float)((Integer)Config.MAX_PROGRESS.get()).intValue()) {
            this.progress -= (float)((Integer)Config.MAX_PROGRESS.get()).intValue();
        }
        this.checkNewType();
        this.checkResource(1, null, 1000, (Integer)Config.WATER_MAX.get(), ResourceType.FLUID);
        this.checkResource(4, Items.REDSTONE_BLOCK, (Integer)Config.POWER_PER_RED.get(), (Integer)Config.POWER_MAX.get(), ResourceType.POWER);
        this.checkResource(3, null, (Integer)Config.FERT_PER_ITEM.get(), (Integer)Config.FERT_MAX.get(), ResourceType.FERT);
        ItemStack slot = this.inventory.getStackInSlot(0);
        this.working = this.getWorking(slot);
        if (!this.working) {
            return;
        }
        this.progress += (float)this.speed;
        if (this.fertilizer > 0) {
            --this.fertilizer;
            this.progress = (float)((double)this.progress + (Double)Config.FERT_MULT.get());
        }
        if (this.fuel.getEnergyStored() >= this.powerUsage) {
            this.fuel.extractEnergy(this.powerUsage, false);
            this.progress = (float)((double)this.progress + (Double)Config.POWER_MULT.get());
        }
        this.playSound();
        if (this.progress < (float)((Integer)Config.MAX_PROGRESS.get()).intValue()) {
            return;
        }
        this.tank.drain(this.fluidUsage);
        ItemStack toAdd = new ItemStack((ItemLike)this.type.getProduct());
        toAdd.setCount(slot.getCount() + this.type.output);
        this.inventory.setStackInSlot(0, toAdd);
        this.setChanged();
    }

    private boolean getWorking(ItemStack slot) {
        if (this.type == null || this.type == CropType.Unknown) {
            return false;
        }
        if (this.tank.getFluidAmount() < this.fluidUsage) {
            return false;
        }
        if (slot.getCount() == 0) {
            return true;
        }
        if (slot.getCount() + this.type.output > slot.getMaxStackSize()) {
            return false;
        }
        return slot.getItem().equals(this.type.product);
    }

    private void checkResource(int slot, Item blockItem, int increment, int maxCapacity, ResourceType type) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (blockItem != null && stack.getItem().equals(blockItem)) {
            increment *= 9;
        }
        if (stack.isEmpty() || stack.getItem().equals(Items.BUCKET) || this.getResourceValue(type) + increment > maxCapacity) {
            return;
        }
        if (stack.getItem().equals(Items.WATER_BUCKET) || stack.getItem().equals(Items.LAVA_BUCKET)) {
            this.inventory.setStackInSlot(slot, new ItemStack((ItemLike)Items.BUCKET, 1));
        } else {
            stack.shrink(1);
            this.inventory.setStackInSlot(slot, stack);
        }
        this.addResource(type, increment);
    }

    private void addResource(ResourceType type, int amount) {
        switch (type.ordinal()) {
            case 0: {
                this.tank.fill(amount);
                break;
            }
            case 1: {
                this.fertilizer += amount;
                break;
            }
            case 2: {
                this.fuel.receiveEnergy(amount, false);
            }
        }
    }

    private void playSound() {
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
            return;
        }
        this.soundCooldown += 20;
        this.level.playSound(null, this.getBlockPos(), ModSounds.WORK_SOUND.get(), SoundSource.BLOCKS);
    }

    private int getResourceValue(ResourceType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.tank.getFluidAmount();
            case 1 -> this.fertilizer;
            case 2 -> this.fuel.getEnergyStored();
        };
    }

    private void checkNewType() {
        CropType newType = this.getCurrentFilter();
        if (this.type == null && newType == null || this.type != null && this.type.equals((Object)newType)) {
            return;
        }
        this.type = newType;
        this.progress = 0.0f;
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveAll(tag);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.saveAll(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.type = CropType.findById(tag.getInt("type"));
        this.fuel = new EnergyStorage(((Integer)Config.POWER_MAX.get()).intValue(), ((Integer)Config.POWER_MAX.get()).intValue(), ((Integer)Config.POWER_MAX.get()).intValue(), tag.getInt("fuel"));
        this.progress = tag.getFloat("progress");
        this.fertilizer = tag.getInt("fertilizer");
        this.tank = WaterTank.create(tag.getInt("water"));
    }

    private void saveAll(CompoundTag tag) {
        tag.putInt("fuel", this.fuel.getEnergyStored());
        tag.putFloat("progress", this.progress);
        tag.putInt("fertilizer", this.fertilizer);
        tag.putInt("water", this.tank.getFluidAmount());
        if (this.type != null) {
            tag.putInt("type", this.type.ordinal());
        }
    }

    private CropType getCurrentFilter() {
        ItemStack stack = this.inventory.getStackInSlot(2);
        return stack.isEmpty() ? CropType.Unknown : CropType.findBySeed(stack.getItem());
    }

    private static enum ResourceType {
        FLUID,
        FERT,
        POWER;

    }
}

