/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.blockentity;

import com.ave.simplestationsfarmer.blockentity.enums.CropGroup;
import com.ave.simplestationsfarmer.blockentity.handlers.InputItemHandler;
import com.ave.simplestationsfarmer.blockentity.handlers.OutputItemHandler;
import com.ave.simplestationsfarmer.blockentity.handlers.SidedItemHandler;
import com.ave.simplestationsfarmer.registrations.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class ModContainer
extends BlockEntity
implements MenuProvider {
    public final SidedItemHandler inventory;
    public static final int OUTPUT_SLOT = 0;
    public static final int FLUID_SLOT = 1;
    public static final int TYPE_SLOT = 2;
    public static final int FERTI_SLOT = 3;
    public static final int REDSTONE_SLOT = 4;

    public ModContainer(BlockEntityType<BlockEntity> entity, BlockPos pos, BlockState state, int size, CropGroup group) {
        super(entity, pos, state);
        this.inventory = new SidedItemHandler(size, group){

            protected void onContentsChanged(int slot) {
                ModContainer.this.setChanged();
            }
        };
    }

    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.FARMER_ENTITY.get(), (be, direction) -> be.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.DARK_FARMER_ENTITY.get(), (be, direction) -> be.getItemHandler((Direction)direction));
    }

    public IItemHandler getItemHandler(Direction side) {
        if (side == Direction.DOWN) {
            return new OutputItemHandler(this.inventory);
        }
        return new InputItemHandler(this.inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.simplestationsfarmer.farmer");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

