/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.blockentity.partblock;

import com.ave.simplestationsfarmer.blockentity.BaseFarmerBlockEntity;
import com.ave.simplestationsfarmer.blockentity.enums.CropType;
import com.ave.simplestationsfarmer.blockentity.handlers.InputItemHandler;
import com.ave.simplestationsfarmer.blockentity.handlers.OutputItemHandler;
import com.ave.simplestationsfarmer.blockentity.handlers.SidedItemHandler;
import com.ave.simplestationsfarmer.registrations.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;

public class PartBlockEntity
extends BlockEntity {
    private BlockPos controllerPos;

    public PartBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PART_ENTITY.get(), pos, state);
    }

    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
        this.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public CropType getCropType() {
        if (this.getController(this) == null) {
            return CropType.Unknown;
        }
        return this.getController((PartBlockEntity)this).type;
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.PART_ENTITY.get(), (be, direction) -> be.getItemHandler((Direction)direction, (PartBlockEntity)((Object)be)));
    }

    public IItemHandler getItemHandler(Direction side, PartBlockEntity be) {
        SidedItemHandler inventory = this.getController((PartBlockEntity)be).inventory;
        if (side == Direction.DOWN) {
            return new OutputItemHandler(inventory);
        }
        return new InputItemHandler(inventory);
    }

    public EnergyStorage getEnergyStorage(PartBlockEntity be) {
        return this.getController((PartBlockEntity)be).fuel;
    }

    public FluidTank getWaterStorage(PartBlockEntity be) {
        return this.getController((PartBlockEntity)be).tank;
    }

    private BaseFarmerBlockEntity getController(PartBlockEntity be) {
        if (be.controllerPos == null) {
            return null;
        }
        return (BaseFarmerBlockEntity)be.getLevel().getBlockEntity(be.controllerPos);
    }

    public boolean isEdge() {
        return this.sameX() || this.sameZ();
    }

    public boolean sameX() {
        if (this.controllerPos == null) {
            return false;
        }
        return this.controllerPos.getX() == this.getBlockPos().getX();
    }

    public boolean sameZ() {
        if (this.controllerPos == null) {
            return false;
        }
        return this.controllerPos.getZ() == this.getBlockPos().getZ();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.controllerPos == null) {
            return;
        }
        tag.putLong("Controller", this.controllerPos.asLong());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.controllerPos = BlockPos.of((long)tag.getLong("Controller"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

