/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.recipes;

import com.ave.simplestationsfarmer.blockentity.enums.CropGroup;
import com.ave.simplestationsfarmer.blockentity.enums.CropType;
import com.ave.simplestationsfarmer.recipes.DarkFarmRecipeCategory;
import com.ave.simplestationsfarmer.recipes.FarmRecipeCategory;
import com.ave.simplestationsfarmer.recipes.ForageFarmRecipeCategory;
import com.ave.simplestationsfarmer.recipes.SimpleRecipe;
import com.ave.simplestationsfarmer.recipes.TreeFarmRecipeCategory;
import com.ave.simplestationsfarmer.registrations.ModBlocks;
import com.ave.simplestationsfarmer.screen.DarkFarmStationScreen;
import com.ave.simplestationsfarmer.screen.FarmStationScreen;
import com.ave.simplestationsfarmer.screen.ForageFarmStationScreen;
import com.ave.simplestationsfarmer.screen.TreeFarmStationScreen;
import com.ave.simplestationsfarmer.uihelpers.UIBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIModPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"simplestationsfarmer", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FarmRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DarkFarmRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeFarmRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ForageFarmRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(FarmRecipeCategory.REGULAR, this.getRecipes(CropGroup.Crop));
        registration.addRecipes(DarkFarmRecipeCategory.REGULAR, this.getRecipes(CropGroup.Dark));
        registration.addRecipes(TreeFarmRecipeCategory.REGULAR, this.getRecipes(CropGroup.Tree));
        registration.addRecipes(ForageFarmRecipeCategory.REGULAR, this.getRecipes(CropGroup.Forage));
    }

    private List<SimpleRecipe> getRecipes(CropGroup group) {
        ArrayList list = Lists.newArrayList();
        for (CropType c : CropType.values()) {
            if (c.equals((Object)CropType.Unknown) || !c.group.equals((Object)group)) continue;
            if (c.seed != null) {
                list.add(new SimpleRecipe(new ItemStack((ItemLike)c.seed), new ItemStack((ItemLike)c.product, c.output)));
            }
            if (c.tag == null) continue;
            list.add(new SimpleRecipe(c.tag));
        }
        return list;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FARMER_BLOCK.get()), new RecipeType[]{FarmRecipeCategory.REGULAR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DARK_FARMER_BLOCK.get()), new RecipeType[]{DarkFarmRecipeCategory.REGULAR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TREE_FARMER_BLOCK.get()), new RecipeType[]{TreeFarmRecipeCategory.REGULAR});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FORAGE_FARMER_BLOCK.get()), new RecipeType[]{ForageFarmRecipeCategory.REGULAR});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FarmStationScreen.class, UIBlocks.OUT_SLOT.left - 16, 6, UIBlocks.OUT_SLOT.width + 32, UIBlocks.OUT_SLOT.height, new RecipeType[]{FarmRecipeCategory.REGULAR});
        registration.addRecipeClickArea(DarkFarmStationScreen.class, UIBlocks.OUT_SLOT.left - 16, 6, UIBlocks.OUT_SLOT.width + 32, UIBlocks.OUT_SLOT.height, new RecipeType[]{DarkFarmRecipeCategory.REGULAR});
        registration.addRecipeClickArea(TreeFarmStationScreen.class, UIBlocks.OUT_SLOT.left - 16, 6, UIBlocks.OUT_SLOT.width + 32, UIBlocks.OUT_SLOT.height, new RecipeType[]{TreeFarmRecipeCategory.REGULAR});
        registration.addRecipeClickArea(ForageFarmStationScreen.class, UIBlocks.OUT_SLOT.left - 16, 6, UIBlocks.OUT_SLOT.width + 32, UIBlocks.OUT_SLOT.height, new RecipeType[]{ForageFarmRecipeCategory.REGULAR});
    }
}

