/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.recipes;

import com.ave.simplestationsfarmer.blockentity.TreeFarmerBlockEntity;
import com.ave.simplestationsfarmer.recipes.SimpleRecipe;
import com.ave.simplestationsfarmer.registrations.ModBlocks;
import com.ave.simplestationsfarmer.uihelpers.UIBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TreeFarmRecipeCategory
implements IRecipeCategory<SimpleRecipe> {
    private static final String Path = "tree_farm";
    public final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"simplestationsfarmer", (String)"tree_farm");
    private final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"simplestationsfarmer", (String)"textures/gui/farm_jei.png");
    public IGuiHelper guiHelper;
    public static RecipeType<SimpleRecipe> REGULAR = RecipeType.create((String)"simplestationsfarmer", (String)"tree_farm", SimpleRecipe.class);
    private final IDrawableStatic bg;

    public TreeFarmRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.bg = guiHelper.createDrawable(this.TEXTURE, 0, 0, 176, 80);
    }

    public RecipeType<SimpleRecipe> getRecipeType() {
        return REGULAR;
    }

    public Component getTitle() {
        return Component.translatable((String)"screen.simplestationsfarmer.tree_farm_recipes");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.TREE_FARMER_BLOCK_ITEM.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SimpleRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.RED_SLOT.left, UIBlocks.RED_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}));
        builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.FERTI_SLOT.left, UIBlocks.FERTI_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL}));
        builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.WATER_SLOT.left, UIBlocks.WATER_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, UIBlocks.OUT_SLOT.left, UIBlocks.OUT_SLOT.top).addItemStack(recipe.outputType);
        builder.addSlot(RecipeIngredientRole.CATALYST, UIBlocks.FILTER_SLOT.left, UIBlocks.FILTER_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{recipe.filter.getItem()}));
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public List<Component> getTooltipStrings(SimpleRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList list = Lists.newArrayList();
        if (UIBlocks.WATER_BAR.isHovered(mouseX, mouseY)) {
            list.add(Component.literal((String)(TreeFarmerBlockEntity.WaterUsage + " mB")));
        }
        return list;
    }
}

