/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.renderer;

import com.ave.simplestationsfarmer.blockentity.enums.CropGroup;
import com.ave.simplestationsfarmer.blockentity.enums.CropType;
import com.ave.simplestationsfarmer.blockentity.partblock.PartBlockEntity;
import com.ave.simplestationsfarmer.registrations.ModBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.data.ModelData;

public class StationRenderer
implements BlockEntityRenderer<PartBlockEntity> {
    private final int treeOffset = CropType.ACACIA.ordinal();
    private final int fruitOffset = CropType.APPLE.ordinal();
    private final int cropOffset = 1;
    private final BakedModel[] cropModels = new BakedModel[this.treeOffset - 1];
    private final BakedModel[] treeCornerModels = new BakedModel[CropType.values().length - this.treeOffset];
    private final BakedModel[] treeEdgeModels = new BakedModel[CropType.values().length - this.treeOffset];
    private final BakedModel[] fruitModels = new BakedModel[this.fruitOffset - 1];

    public StationRenderer(BlockEntityRendererProvider.Context context) {
        int i;
        BlockModelShaper shaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        for (i = 0; i < this.treeOffset - 1; ++i) {
            this.cropModels[i] = shaper.getBlockModel(((Block)ModBlocks.CROP_BLOCKS[i].get()).defaultBlockState());
        }
        for (i = 0; i < this.fruitOffset - this.treeOffset; ++i) {
            this.treeCornerModels[i] = shaper.getBlockModel(((Block)ModBlocks.TREE_CORNER_BLOCKS[i].get()).defaultBlockState());
            this.treeEdgeModels[i] = shaper.getBlockModel(((Block)ModBlocks.TREE_EDGE_BLOCKS[i].get()).defaultBlockState());
        }
        for (i = 0; i < CropType.values().length - this.fruitOffset; ++i) {
            this.fruitModels[i] = shaper.getBlockModel(((Block)ModBlocks.FRUIT_BLOCKS[i].get()).defaultBlockState());
        }
    }

    public void render(PartBlockEntity be, float pt, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        CropType type = be.getCropType();
        if (type == null || type == CropType.Unknown) {
            return;
        }
        pose.pushPose();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = type.group == CropGroup.Tree ? this.getTreeModel(pose, type, be) : (type.group == CropGroup.Forage ? this.fruitModels[type.ordinal() - this.fruitOffset] : this.cropModels[type.ordinal() - 1]);
        dispatcher.getModelRenderer().renderModel(pose.last(), buf.getBuffer(RenderType.cutout()), null, model, 1.0f, 1.0f, 1.0f, light, overlay, ModelData.EMPTY, null);
        pose.popPose();
    }

    private BakedModel getTreeModel(PoseStack pose, CropType type, PartBlockEntity be) {
        BakedModel model;
        BakedModel bakedModel = model = be.isEdge() ? this.treeEdgeModels[type.ordinal() - this.treeOffset] : this.treeCornerModels[type.ordinal() - this.treeOffset];
        if (be.isEdge() && be.sameZ()) {
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose(Axis.YP.rotationDegrees(90.0f));
            pose.translate(-0.5, -0.5, -0.5);
        }
        return model;
    }
}

