/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.screen;

import com.ave.simplestationsfarmer.Config;
import com.ave.simplestationsfarmer.blockentity.BaseFarmerBlockEntity;
import com.ave.simplestationsfarmer.blockentity.ModContainer;
import com.ave.simplestationsfarmer.blockentity.handlers.WaterTank;
import com.ave.simplestationsfarmer.uihelpers.UIBlocks;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public abstract class BaseStationMenu
extends AbstractContainerMenu {
    public final Level level;
    public final ModContainer blockEntity;

    public BaseStationMenu(int containerId, Inventory inventory, FriendlyByteBuf data, MenuType menu) {
        this(containerId, inventory, (ModContainer)inventory.player.level().getBlockEntity(data.readBlockPos()), menu);
    }

    public BaseStationMenu(int containerId, Inventory inventory, ModContainer be, MenuType menu) {
        super(menu, containerId);
        this.level = inventory.player.level();
        this.blockEntity = be;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 0, UIBlocks.OUT_SLOT.left, UIBlocks.OUT_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 1, UIBlocks.WATER_SLOT.left, UIBlocks.WATER_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 2, UIBlocks.FILTER_SLOT.left, UIBlocks.FILTER_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 3, UIBlocks.FERTI_SLOT.left, UIBlocks.FERTI_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 4, UIBlocks.RED_SLOT.left, UIBlocks.RED_SLOT.top));
        ModContainer modContainer = this.blockEntity;
        if (modContainer instanceof BaseFarmerBlockEntity) {
            BaseFarmerBlockEntity miner = (BaseFarmerBlockEntity)modContainer;
            this.addDataSlots(miner);
        }
    }

    private void addDataSlots(final BaseFarmerBlockEntity miner) {
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.fertilizer;
            }

            public void set(int value) {
                miner.fertilizer = value;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.tank.getFluidAmount();
            }

            public void set(int value) {
                miner.tank = WaterTank.create(value);
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return (int)miner.progress;
            }

            public void set(int value) {
                miner.progress = value;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.working ? 1 : 0;
            }

            public void set(int value) {
                miner.working = value != 0;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.fuel.getEnergyStored();
            }

            public void set(int value) {
                miner.fuel = new EnergyStorage(((Integer)Config.POWER_MAX.get()).intValue(), 0, 0, value);
            }
        });
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        int HOTBAR_SLOT_COUNT = 9;
        int PLAYER_INVENTORY_ROW_COUNT = 3;
        int PLAYER_INVENTORY_COLUMN_COUNT = 9;
        int PLAYER_INVENTORY_SLOT_COUNT = PLAYER_INVENTORY_COLUMN_COUNT * PLAYER_INVENTORY_ROW_COUNT;
        int VANILLA_SLOT_COUNT = HOTBAR_SLOT_COUNT + PLAYER_INVENTORY_SLOT_COUNT;
        int VANILLA_FIRST_SLOT_INDEX = 0;
        int TE_INVENTORY_FIRST_SLOT_INDEX = VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT;
        int TE_INVENTORY_SLOT_COUNT = 5;
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, TE_INVENTORY_FIRST_SLOT_INDEX, TE_INVENTORY_FIRST_SLOT_INDEX + TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < TE_INVENTORY_FIRST_SLOT_INDEX + TE_INVENTORY_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, VANILLA_FIRST_SLOT_INDEX, VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + k * 9 + 9, 8 + j * 18, 84 + k * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
    }
}

