/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsfarmer.screen;

import com.ave.simplestationsfarmer.Config;
import com.ave.simplestationsfarmer.blockentity.BaseFarmerBlockEntity;
import com.ave.simplestationsfarmer.blockentity.ModContainer;
import com.ave.simplestationsfarmer.screen.BaseStationMenu;
import com.ave.simplestationsfarmer.uihelpers.NumToString;
import com.ave.simplestationsfarmer.uihelpers.UIBlocks;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class BaseStationScreen
extends AbstractContainerScreen<BaseStationMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"simplestationsfarmer", (String)"textures/gui/station_gui.png");

    public BaseStationScreen(BaseStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.render(gfx, mouseX, mouseY, partialTicks);
        this.renderTooltip(gfx, mouseX, mouseY);
        ModContainer modContainer = ((BaseStationMenu)this.menu).blockEntity;
        if (!(modContainer instanceof BaseFarmerBlockEntity)) {
            return;
        }
        BaseFarmerBlockEntity miner = (BaseFarmerBlockEntity)modContainer;
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        if (UIBlocks.WATER_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String waterPart = NumToString.parse((float)miner.tank.getFluidAmount() / 1000.0f, "B / ") + NumToString.parse((float)((Integer)Config.WATER_MAX.get()).intValue() / 1000.0f, "B");
            List<Component> waterText = Arrays.asList(Component.translatable((String)"screen.simplestationsfarmer.water"), Component.literal((String)waterPart));
            gfx.renderComponentTooltip(this.font, waterText, mouseX, mouseY);
        }
        if (UIBlocks.FERTI_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String fertPart = miner.fertilizer + " / " + String.valueOf(Config.FERT_MAX.get());
            List<Component> fertText = Arrays.asList(Component.translatable((String)"screen.simplestationsfarmer.fertilizer"), Component.literal((String)fertPart));
            gfx.renderComponentTooltip(this.font, fertText, mouseX, mouseY);
        }
        if (UIBlocks.POWER_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String powerPart = NumToString.parse(miner.fuel.getEnergyStored(), "RF / ") + NumToString.parse(((Integer)Config.POWER_MAX.get()).intValue(), "RF");
            List<Component> powerText = Arrays.asList(Component.translatable((String)"screen.simplestationsfarmer.power"), Component.literal((String)powerPart));
            gfx.renderComponentTooltip(this.font, powerText, mouseX, mouseY);
        }
        if (miner.progress > 0.0f && UIBlocks.PROGRESS_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            int progressPart = (int)Math.ceil(100.0f * miner.progress / (float)((Integer)Config.MAX_PROGRESS.get()).intValue());
            gfx.renderTooltip(this.font, (Component)Component.literal((String)(progressPart + "%")), mouseX, mouseY);
        }
        if (miner.type == null && UIBlocks.FILTER_SLOT.isHovered(mouseX - startX, mouseY - startY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)"screen.simplestationsfarmer.filter"), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics graphics, float tick, int mx, int my) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        int textWidth = this.font.width((FormattedText)this.getTitle());
        int centerX = this.width / 2 - textWidth / 2;
        graphics.drawString(this.font, this.getTitle(), centerX, y + 6, 0x222222, false);
        ModContainer modContainer = ((BaseStationMenu)this.menu).blockEntity;
        if (!(modContainer instanceof BaseFarmerBlockEntity)) {
            return;
        }
        BaseFarmerBlockEntity miner = (BaseFarmerBlockEntity)modContainer;
        int tickAlpha = 96 + (int)(63.0 * Math.sin((double)System.currentTimeMillis() / 400.0));
        int borderColor = tickAlpha << 24 | 0xFF0000;
        float progressPart = miner.progress / (float)((Integer)Config.MAX_PROGRESS.get()).intValue();
        UIBlocks.PROGRESS_BAR.drawProgressToRight(graphics, x, y, progressPart, -3342627);
        float waterPart = miner.tank.getPercent();
        UIBlocks.WATER_BAR.drawProgressToTop(graphics, x, y, waterPart, this.getFluidColor());
        if (miner.tank.getFluidAmount() < miner.fluidUsage) {
            UIBlocks.WATER_SLOT.drawBorder(graphics, x, y, borderColor);
        }
        float fertPart = (float)miner.fertilizer / (float)((Integer)Config.FERT_MAX.get()).intValue();
        UIBlocks.FERTI_BAR.drawProgressToTop(graphics, x, y, fertPart, this.getFertColor());
        float powerPart = (float)miner.fuel.getEnergyStored() / (float)((Integer)Config.POWER_MAX.get()).intValue();
        UIBlocks.POWER_BAR.drawProgressToTop(graphics, x, y, powerPart, -1430576623);
    }

    public int getFertColor() {
        return 0;
    }

    public int getFluidColor() {
        return -1440603495;
    }
}

