/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1406;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FennecEntity
extends class_1321
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 5.0f;
    public static final float TAMED_HEALTH = 12.0f;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(FennecEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(FennecEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHRIEKING = class_2945.method_12791(FennecEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private FennecFleeGoal<class_1657> fleeGoal;

    public FennecEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new FennecMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.26).method_26868(class_5134.field_23721, 1.8);
    }

    public static boolean canSpawn(class_1299<FennecEntity> entityType, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2680 groundBlock = world.method_8320(pos.method_10074());
        boolean validDesertBlock = groundBlock.method_26164(class_3481.field_15466);
        return validDesertBlock && world.method_22335(pos, 0) > 8 && world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(12.0);
            this.method_6033(12.0f);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        class_1315 result = super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        return result;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(SHRIEKING, (Object)false);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().id);
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10556("Shrieking", this.isShrieking());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
        this.setSleeping(tag.method_10577("Sleeping"));
        this.setShrieking(tag.method_10577("Shrieking"));
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isShrieking() {
        return (Boolean)this.field_6011.method_12789(SHRIEKING);
    }

    public void setShrieking(boolean shrieking) {
        this.field_6011.method_12778(SHRIEKING, (Object)shrieking);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.5){

            public boolean method_6264() {
                return !FennecEntity.this.method_6181() && super.method_6264();
            }
        });
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.35, true));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.35, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8504}), false));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new AlertOnHostileGoal(this));
        this.field_6201.method_6277(6, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(7, (class_1352)new class_1350(this, 1.3, 10.0f, 2.0f, false){

            public boolean method_6264() {
                return super.method_6264() && !FennecEntity.this.method_6172();
            }
        });
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(7, (class_1352)new class_1404((class_1321)this, class_1428.class, true, null));
        this.field_6185.method_6277(8, (class_1352)new class_1404((class_1321)this, class_1463.class, true, null));
        this.field_6185.method_6277(9, (class_1352)new class_1404((class_1321)this, MouseEntity.class, true, null));
    }

    protected void method_6175() {
        if (this.fleeGoal == null) {
            this.fleeGoal = new FennecFleeGoal<class_1657>(this, class_1657.class, 16.0f, 1.0, 1.5);
        }
        this.field_6201.method_6280(this.fleeGoal);
        if (!this.method_6181()) {
            this.field_6201.method_6277(4, this.fleeGoal);
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_6181() && this.method_35057() != null && target == this.method_35057()) {
            return;
        }
        super.method_5980(target);
    }

    public boolean method_6121(class_1297 target) {
        boolean flag = target.method_5643(this.method_48923().method_48812((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (target instanceof class_1428 || target instanceof class_1463) {
            return super.method_6121(target);
        }
        return flag;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        if (this.method_6172()) {
            this.method_6179(false);
        }
        return result;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (this.method_6113()) {
                this.setSleeping(false);
                this.method_24346(true);
                this.method_6179(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8726) {
                if (this.method_6032() < this.method_6063()) {
                    this.method_6025(3.0f);
                    if (!player.method_31549().field_7477) {
                        itemstack.method_7934(1);
                    }
                    for (int i = 0; i < 5; ++i) {
                        double offsetX = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetY = (this.field_5974.method_43058() - 0.5) * 1.0;
                        double offsetZ = (this.field_5974.method_43058() - 0.5) * 1.0;
                        this.method_37908().method_8406((class_2394)FaunifyParticleTypes.HEALTH, this.method_23317() + offsetX, this.method_23318() + (double)this.method_5751() + offsetY, this.method_23321() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.method_24346(!this.method_24345());
                    this.method_6179(!this.method_6172());
                    if (this.method_6172()) {
                        this.field_6282 = false;
                        this.field_6189.method_6340();
                        this.method_5980(null);
                    }
                }
                return class_1269.field_5812;
            }
            if (item == class_1802.field_8504) {
                if (!this.method_6479() && this.method_5618() == 0) {
                    if (!this.method_37908().field_9236) {
                        this.method_6480(player);
                        if (!player.method_31549().field_7477) {
                            itemstack.method_7934(1);
                        }
                    }
                } else {
                    this.method_24346(!this.method_24345());
                    this.method_6179(!this.method_6172());
                    if (this.method_6172()) {
                        this.field_6282 = false;
                        this.field_6189.method_6340();
                        this.method_5980(null);
                    }
                }
                return class_1269.field_5812;
            }
            if (itemstack.method_7960() || item != class_1802.field_8504 && item != class_1802.field_8726) {
                this.method_24346(!this.method_24345());
                this.method_6179(!this.method_6172());
                if (this.method_6172()) {
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                }
                return class_1269.field_5812;
            }
        }
        if (item == class_1802.field_8726 && !this.method_6181()) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (!this.method_37908().field_9236) {
                if (this.field_5974.method_43048(3) == 0) {
                    this.method_6170(player);
                    this.method_6173(true);
                    this.method_24346(true);
                    this.method_6179(true);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8504;
    }

    public FennecEntity createChild(class_3218 serverLevel, class_1296 otherParent) {
        FennecEntity babyFennec = (FennecEntity)FaunifyEntities.FENNEC.method_5883((class_1937)serverLevel);
        if (babyFennec != null && otherParent instanceof FennecEntity) {
            FennecEntity parent = (FennecEntity)otherParent;
            if (this.method_6181()) {
                babyFennec.method_6174(this.method_6139());
                babyFennec.method_6173(true);
            }
            Variant selectedVariant = this.field_5974.method_43056() ? this.getVariant() : parent.getVariant();
            babyFennec.setVariant(selectedVariant);
            babyFennec.method_5971();
        }
        return babyFennec;
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(2);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.FENNEC_IDLE_1;
            }
            case 1: {
                return FaunifySounds.FENNEC_IDLE_2;
            }
        }
        return FaunifySounds.FENNEC_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.FENNEC_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<FennecEntity> event) {
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (target instanceof class_1428 || target instanceof class_1463) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_8504;
        }
        return false;
    }

    static class FennecMoveControl
    extends class_1335 {
        private final FennecEntity fennec;

        public FennecMoveControl(FennecEntity fennecEntity) {
            super((class_1308)fennecEntity);
            this.fennec = fennecEntity;
        }

        public void method_6240() {
            if (!this.fennec.method_6113()) {
                super.method_6240();
            }
        }
    }

    public static enum Variant implements class_3542
    {
        LIGHT(0, "light"),
        DARK(1, "dark");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    public class AlertOnHostileGoal
    extends class_1352 {
        private final FennecEntity fennec;
        private final class_1937 level;

        public AlertOnHostileGoal(FennecEntity fennec) {
            this.fennec = fennec;
            this.level = fennec.method_37908();
        }

        public boolean method_6264() {
            if (this.fennec.method_35057() instanceof class_1657) {
                List nearbyMobs = this.level.method_8390(class_1309.class, this.fennec.method_5829().method_1014(10.0), entity -> entity instanceof class_1588);
                return !nearbyMobs.isEmpty();
            }
            return false;
        }

        public void method_6269() {
            this.fennec.setShrieking(true);
            this.fennec.method_5783(FaunifySounds.FENNEC_ALERT, 1.0f, 1.0f);
            List nearbyMobs = this.level.method_8390(class_1309.class, this.fennec.method_5829().method_1014(15.0), entity -> entity instanceof class_1588);
            for (class_1309 mob : nearbyMobs) {
                mob.method_6092(new class_1293(class_1294.field_5912, 200, 0));
            }
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = FennecEntity.this.field_5974.method_43048(SleepGoal.method_38848((int)countdownTime));
            this.method_6265(EnumSet.noneOf(class_1352.class_4134.class));
        }

        public boolean method_6264() {
            if (FennecEntity.this.method_5799()) {
                return false;
            }
            if (FennecEntity.this.field_6212 == 0.0f && FennecEntity.this.field_6227 == 0.0f && FennecEntity.this.field_6250 == 0.0f) {
                return this.canSleep() || FennecEntity.this.method_6113();
            }
            return false;
        }

        public boolean method_6266() {
            if (FennecEntity.this.method_5799()) {
                return false;
            }
            if (FennecEntity.this.method_6181() && !FennecEntity.this.method_6172()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return FennecEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            FennecEntity.this.setSleeping(false);
            this.countdown = FennecEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            FennecEntity.this.method_6100(false);
            FennecEntity.this.setSleeping(true);
            FennecEntity.this.method_5942().method_6340();
            FennecEntity.this.method_5962().method_6239(FennecEntity.this.method_23317(), FennecEntity.this.method_23318(), FennecEntity.this.method_23321(), 0.0);
        }
    }

    static class FennecFleeGoal<T extends class_1309>
    extends class_1338<T> {
        private final FennecEntity fennec;

        public FennecFleeGoal(FennecEntity fennec, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super((class_1314)fennec, fleeFromType, distance, slowSpeed, fastSpeed, class_1301.field_6156::test);
            this.fennec = fennec;
        }

        public boolean method_6264() {
            if (this.fennec.method_6181()) {
                return false;
            }
            if (!super.method_6264()) {
                return false;
            }
            class_1309 class_13092 = this.field_6390;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                class_1799 mainHand = player.method_6047();
                class_1799 offHand = player.method_6079();
                return !mainHand.method_31574(class_1802.field_8504) && !offHand.method_31574(class_1802.field_8504);
            }
            return true;
        }

        public boolean method_6266() {
            if (this.fennec.method_6181()) {
                return false;
            }
            if (!super.method_6266()) {
                return false;
            }
            class_1309 class_13092 = this.field_6390;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                class_1799 mainHand = player.method_6047();
                class_1799 offHand = player.method_6079();
                return !mainHand.method_31574(class_1802.field_8504) && !offHand.method_31574(class_1802.field_8504);
            }
            return true;
        }
    }
}

