/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7995;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class OpossumEntity
extends class_1429
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 15.0f;
    private static final int HOLDING_DURATION = 1200;
    private static final int EATING_DURATION = 120;
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BABY_COUNT = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_RIDDEN = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> RIDING_COOLDOWN = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PLAYING_DEAD = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> PLAY_DEAD_COOLDOWN = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHOULD_PLAY_DEAD = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> DATA_MOUTH_ITEM = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> EATING_TIMER = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_ACTIVELY_EATING = class_2945.method_12791(OpossumEntity.class, (class_2941)class_2943.field_13323);
    private static final Predicate<class_1542> ALLOWED_ITEMS = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805() && itemEntity.method_6983().method_31574(class_1802.field_16998);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean aggressive = false;
    private boolean shouldSpawnBabies = false;
    private int deferredBabyCount = 0;
    private int babySpawnTimer = 0;

    public OpossumEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5996(class_5134.field_23716).method_6192(15.0);
        this.method_6033(15.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 2.0);
    }

    public static boolean canSpawn(class_1299<OpossumEntity> entityType, class_1936 level, class_3730 spawnType, class_2338 position, class_5819 random) {
        return class_1429.method_39448((class_1920)level, (class_2338)position);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        super.method_5943(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        if (!this.method_37908().field_9236 && !this.method_6109()) {
            class_5819 random = world.method_8409();
            int roll = random.method_43048(100);
            int babyCount = roll < 25 ? 0 : (roll < 70 ? 1 : 2);
            this.setBabyCount(babyCount);
            if (babyCount > 0) {
                this.deferredBabyCount = babyCount;
                this.shouldSpawnBabies = true;
                this.babySpawnTimer = 5;
            }
        }
        return spawnData;
    }

    public void method_5773() {
        int playDeadCooldown;
        int cooldown;
        super.method_5773();
        if (this.method_6109() && this.method_5765()) {
            this.handleBabyPassengerSleep();
        }
        if (this.shouldSpawnBabies && !this.method_37908().field_9236) {
            if (this.babySpawnTimer > 0) {
                --this.babySpawnTimer;
            } else if (this.method_37908() instanceof class_3218) {
                this.spawnBabies();
            }
        }
        if (!this.method_37908().field_9236 && this.method_6109() && (cooldown = this.getRidingCooldown()) > 0) {
            this.setRidingCooldown(cooldown - 1);
        }
        if (!this.method_37908().field_9236 && (playDeadCooldown = this.getPlayDeadCooldown()) > 0) {
            this.setPlayDeadCooldown(playDeadCooldown - 1);
        }
        if (!this.method_37908().field_9236) {
            for (class_1297 passenger : this.method_5685()) {
                OpossumEntity babyOpossum;
                if (!(passenger instanceof OpossumEntity) || (babyOpossum = (OpossumEntity)passenger).method_6109()) continue;
                passenger.method_5848();
                babyOpossum.setHasRidden(false);
            }
        }
        this.handleEatingBerry();
    }

    public void method_5620(int growthSeconds, boolean forced) {
        super.method_5620(growthSeconds, forced);
        if (!this.method_6109() && this.method_5765()) {
            this.method_5848();
            this.setHasRidden(false);
        }
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_5818(class_1297 passenger) {
        if (!(passenger instanceof OpossumEntity)) {
            return false;
        }
        OpossumEntity opossumPassenger = (OpossumEntity)passenger;
        return !this.method_6109() && opossumPassenger.method_6109() && this.method_5685().size() < 2 && !this.isPlayingDead();
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (!(passenger instanceof OpossumEntity)) {
            return;
        }
        int currentBabyRiders = 0;
        for (class_1297 e : this.method_5685()) {
            OpossumEntity opossum;
            if (!(e instanceof OpossumEntity) || !(opossum = (OpossumEntity)e).method_6109()) continue;
            ++currentBabyRiders;
        }
        int index = this.method_5685().indexOf(passenger);
        if (index == -1) {
            return;
        }
        double sideOffset = 0.0;
        if (currentBabyRiders == 2) {
            if (index == 0) {
                sideOffset = -0.15;
            } else if (index == 1) {
                sideOffset = 0.15;
            }
        } else {
            sideOffset = 0.0;
        }
        float yaw = this.method_36454();
        double radians = Math.toRadians(yaw + 180.0f);
        double offsetX = Math.cos(radians) * sideOffset;
        double offsetZ = Math.sin(radians) * sideOffset;
        double yOffset = (double)this.method_17682() * 0.8;
        passenger.method_23327(this.method_23317() + offsetX, this.method_23318() + yOffset, this.method_23321() + offsetZ);
    }

    public boolean method_6121(class_1297 target) {
        boolean flag = target.method_5643(this.method_48923().method_48812((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (target instanceof MouseEntity || target instanceof class_1463) {
            return super.method_6121(target);
        }
        return flag;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (source.method_49708(class_8111.field_42353)) {
            return false;
        }
        if (this.method_6113()) {
            this.setSleeping(false);
        }
        if (!this.method_37908().field_9236 && this.method_6032() <= 8.0f && !this.isPlayingDead() && this.getPlayDeadCooldown() <= 0) {
            this.setShouldPlayDead(true);
        }
        if (!this.method_37908().field_9236) {
            this.dropMouthItem();
        }
        if (!this.method_6109() && this.hasBabyPassengers()) {
            this.dismountBabies();
        }
        if (this.method_6109() && this.method_5765()) {
            class_1297 class_12972;
            class_1297 adult = this.method_5854();
            this.method_5848();
            this.setHasRidden(false);
            this.setRidingCooldown(100);
            if (this.method_6032() <= 8.0f) {
                this.setPlayDeadCooldown(20);
                this.setShouldPlayDead(true);
            }
            if ((class_12972 = source.method_5529()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (adult instanceof OpossumEntity) {
                    OpossumEntity adultOpossum = (OpossumEntity)adult;
                    adultOpossum.method_5980((class_1309)player);
                    adultOpossum.setAggressive(true);
                    this.method_5783(FaunifySounds.OPOSSUM_ANGRY, 1.0f, 1.0f);
                }
            }
        }
        return result;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(HAS_RIDDEN, (Object)false);
        this.field_6011.method_12784(BABY_COUNT, (Object)0);
        this.field_6011.method_12784(DATA_VARIANT_ID, (Object)0);
        this.field_6011.method_12784(RIDING_COOLDOWN, (Object)0);
        this.field_6011.method_12784(PLAYING_DEAD, (Object)false);
        this.field_6011.method_12784(PLAY_DEAD_COOLDOWN, (Object)0);
        this.field_6011.method_12784(SHOULD_PLAY_DEAD, (Object)false);
        this.field_6011.method_12784(DATA_MOUTH_ITEM, (Object)class_1799.field_8037);
        this.field_6011.method_12784(EATING_TIMER, (Object)0);
        this.field_6011.method_12784(IS_ACTIVELY_EATING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariant().id);
        nbt.method_10556("Sleeping", this.method_6113());
        nbt.method_10556("PlayingDead", this.isPlayingDead());
        nbt.method_10556("ShouldPlayDead", this.getShouldPlayDead());
        nbt.method_10549("PosX", this.method_23317());
        nbt.method_10549("PosY", this.method_23318());
        nbt.method_10549("PosZ", this.method_23321());
        nbt.method_10556("ShouldSpawnBabies", this.shouldSpawnBabies);
        nbt.method_10569("DeferredBabyCount", this.deferredBabyCount);
        nbt.method_10569("BabySpawnTimer", this.babySpawnTimer);
        nbt.method_10569("RidingCooldown", this.getRidingCooldown());
        nbt.method_10569("PlayDeadCooldown", this.getPlayDeadCooldown());
        nbt.method_10569("EatingTimer", this.getEatingTimer());
        nbt.method_10556("ActivelyEating", this.isActivelyEating());
        class_1799 itemstack = this.getMouthItem();
        if (!itemstack.method_7960()) {
            nbt.method_10566("MouthItem", (class_2520)itemstack.method_7953(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.byId(nbt.method_10550("Variant")));
        this.setSleeping(nbt.method_10577("Sleeping"));
        boolean savedPlayingDead = nbt.method_10577("PlayingDead");
        if (savedPlayingDead && !this.method_37908().field_9236) {
            this.setPlayingDead(false);
            this.setPlayDeadCooldown(20);
        } else {
            this.setPlayingDead(savedPlayingDead);
        }
        this.setShouldPlayDead(nbt.method_10577("ShouldPlayDead"));
        if (nbt.method_10545("PosX") && nbt.method_10545("PosY") && nbt.method_10545("PosZ")) {
            double posX = nbt.method_10574("PosX");
            double posY = nbt.method_10574("PosY");
            double posZ = nbt.method_10574("PosZ");
            this.method_23327(posX, posY, posZ);
        }
        this.shouldSpawnBabies = nbt.method_10577("ShouldSpawnBabies");
        this.deferredBabyCount = nbt.method_10550("DeferredBabyCount");
        this.babySpawnTimer = nbt.method_10550("BabySpawnTimer");
        this.setRidingCooldown(nbt.method_10550("RidingCooldown"));
        this.setPlayDeadCooldown(nbt.method_10550("PlayDeadCooldown"));
        this.setEatingTimer(nbt.method_10550("EatingTimer"));
        this.setActivelyEating(nbt.method_10577("ActivelyEating"));
        if (nbt.method_10573("MouthItem", 10)) {
            this.setMouthItem(class_1799.method_7915((class_2487)nbt.method_10562("MouthItem")));
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.field_6011.method_12789(PLAYING_DEAD);
    }

    public void setPlayingDead(boolean playingDead) {
        this.field_6011.method_12778(PLAYING_DEAD, (Object)playingDead);
    }

    public boolean getShouldPlayDead() {
        return (Boolean)this.field_6011.method_12789(SHOULD_PLAY_DEAD);
    }

    public void setShouldPlayDead(boolean shouldPlayDead) {
        this.field_6011.method_12778(SHOULD_PLAY_DEAD, (Object)shouldPlayDead);
    }

    public class_1799 getMouthItem() {
        return (class_1799)this.field_6011.method_12789(DATA_MOUTH_ITEM);
    }

    public void setMouthItem(class_1799 stack) {
        this.field_6011.method_12778(DATA_MOUTH_ITEM, (Object)stack);
    }

    public int getEatingTimer() {
        return (Integer)this.field_6011.method_12789(EATING_TIMER);
    }

    public void setEatingTimer(int timer) {
        this.field_6011.method_12778(EATING_TIMER, (Object)timer);
    }

    public boolean isActivelyEating() {
        return (Boolean)this.field_6011.method_12789(IS_ACTIVELY_EATING);
    }

    public void setActivelyEating(boolean eating) {
        this.field_6011.method_12778(IS_ACTIVELY_EATING, (Object)eating);
    }

    public void setHasRidden(boolean value) {
        this.field_6011.method_12778(HAS_RIDDEN, (Object)value);
    }

    public boolean hasRidden() {
        return (Boolean)this.field_6011.method_12789(HAS_RIDDEN);
    }

    public void setBabyCount(int count) {
        this.field_6011.method_12778(BABY_COUNT, (Object)count);
    }

    public int getBabyCount() {
        return (Integer)this.field_6011.method_12789(BABY_COUNT);
    }

    public void setAggressive(boolean angry) {
        this.aggressive = angry;
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    public void setRidingCooldown(int ticks) {
        this.field_6011.method_12778(RIDING_COOLDOWN, (Object)ticks);
    }

    public int getRidingCooldown() {
        return (Integer)this.field_6011.method_12789(RIDING_COOLDOWN);
    }

    public boolean canRideAdult() {
        return this.getRidingCooldown() <= 0;
    }

    public void setPlayDeadCooldown(int ticks) {
        this.field_6011.method_12778(PLAY_DEAD_COOLDOWN, (Object)ticks);
    }

    public int getPlayDeadCooldown() {
        return (Integer)this.field_6011.method_12789(PLAY_DEAD_COOLDOWN);
    }

    public boolean hasBabyPassengers() {
        return this.method_5685().stream().anyMatch(entity -> {
            OpossumEntity opossum;
            return entity instanceof OpossumEntity && (opossum = (OpossumEntity)((Object)entity)).method_6109();
        });
    }

    public void dismountBabies() {
        if (!this.method_37908().field_9236) {
            OpossumEntity babyOpossum;
            ArrayList<class_1297> passengersToRemove = new ArrayList<class_1297>();
            for (class_1297 passenger : this.method_5685()) {
                if (!(passenger instanceof OpossumEntity) || !(babyOpossum = (OpossumEntity)passenger).method_6109()) continue;
                passengersToRemove.add(passenger);
            }
            for (class_1297 passenger : passengersToRemove) {
                passenger.method_5848();
                if (!(passenger instanceof OpossumEntity)) continue;
                babyOpossum = (OpossumEntity)passenger;
                babyOpossum.setHasRidden(false);
                babyOpossum.setRidingCooldown(200);
            }
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new PlayDeadGoal());
        this.field_6201.method_6277(2, (class_1352)new OpossumEatBerriesGoal(1.0, 16, 2));
        this.field_6201.method_6277(3, (class_1352)new OpossumSearchForItemsGoal());
        this.field_6201.method_6277(4, (class_1352)new FollowAdultOpossumGoal(this, 1.0, 2.0f, 10.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.1, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_16998}), false));
        this.field_6201.method_6277(7, (class_1352)new SleepGoal(200));
        this.field_6201.method_6277(9, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1366((class_1314)this, 1.0, true){

            public boolean method_6264() {
                return OpossumEntity.this.isAggressive() && super.method_6264();
            }

            public boolean method_6266() {
                return OpossumEntity.this.isAggressive() && super.method_6266();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1400<class_1657>((class_1308)this, class_1657.class, true){

            public boolean method_6264() {
                return OpossumEntity.this.isAggressive() && super.method_6264();
            }
        });
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (item == class_1802.field_16998 && !this.method_6479() && this.method_5618() == 0) {
            if (!this.method_37908().field_9236) {
                if (this.hasBabyPassengers()) {
                    this.dismountBabies();
                }
                this.method_6480(player);
                if (!player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_16998;
    }

    public void method_6480(@Nullable class_1657 player) {
        if (this.hasBabyPassengers()) {
            this.dismountBabies();
        }
        super.method_6480(player);
    }

    public OpossumEntity createChild(class_3218 serverLevel, class_1296 otherParent) {
        OpossumEntity babyOpossum = (OpossumEntity)FaunifyEntities.OPOSSUM.method_5883((class_1937)serverLevel);
        if (babyOpossum != null && otherParent instanceof OpossumEntity) {
            OpossumEntity parent = (OpossumEntity)otherParent;
            Variant selectedVariant = this.field_5974.method_43056() ? this.getVariant() : parent.getVariant();
            babyOpossum.setVariant(selectedVariant);
        }
        return babyOpossum;
    }

    protected class_3414 method_5994() {
        int soundIndex = this.field_5974.method_43048(2);
        switch (soundIndex) {
            case 0: {
                return FaunifySounds.OPOSSUM_IDLE_1;
            }
            case 1: {
                return FaunifySounds.OPOSSUM_IDLE_2;
            }
        }
        return FaunifySounds.OPOSSUM_IDLE_1;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FaunifySounds.OPOSSUM_HURT;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<OpossumEntity> event) {
        class_1309 target = this.method_5968();
        class_243 velocity = this.method_18798();
        double horizontalSpeedSq = velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350;
        double movingThreshold = 0.001;
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
            target = null;
        }
        if (this.method_6113()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isPlayingDead()) {
            event.getController().setAnimation(RawAnimation.begin().then("play_dead", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (horizontalSpeedSq > movingThreshold) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        class_1657 player = this.method_37908().method_18460((class_1297)this, 10.0);
        if (player != null) {
            class_1799 heldItem = player.method_6047();
            return heldItem.method_7909() == class_1802.field_16998;
        }
        return false;
    }

    private void spawnBabies() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        for (int i = 0; i < this.deferredBabyCount; ++i) {
            OpossumEntity baby = (OpossumEntity)FaunifyEntities.OPOSSUM.method_5883(this.method_37908());
            if (baby == null) continue;
            baby.method_7217(true);
            baby.setVariant(this.getVariant());
            baby.method_5943((class_5425)serverLevel, this.method_37908().method_8404(this.method_24515()), class_3730.field_16459, null, null);
            baby.setVariant(this.getVariant());
            baby.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
            this.method_37908().method_8649((class_1297)baby);
            baby.method_5873((class_1297)this, true);
            baby.setHasRidden(true);
        }
        this.deferredBabyCount = 0;
        this.shouldSpawnBabies = false;
        this.babySpawnTimer = 0;
    }

    private void handleBabyPassengerSleep() {
        if (!this.method_37908().field_9236) {
            boolean shouldSleep = this.method_37908().method_23886();
            if (shouldSleep && !this.method_6113()) {
                this.setSleeping(true);
            } else if (!shouldSleep && this.method_6113()) {
                this.setSleeping(false);
            }
        }
    }

    private void handleEatingBerry() {
        if (!this.getMouthItem().method_7960() && this.getMouthItem().method_31574(class_1802.field_16998)) {
            if (!this.method_37908().field_9236) {
                int currentTimer = this.getEatingTimer();
                if (currentTimer == 0) {
                    this.setEatingTimer(1320);
                    this.setActivelyEating(false);
                } else if (currentTimer > 0) {
                    this.setEatingTimer(currentTimer - 1);
                    if (currentTimer == 121) {
                        this.setActivelyEating(true);
                    }
                    if (currentTimer <= 120 && this.isActivelyEating() && currentTimer % 40 == 0) {
                        this.createEatingParticles();
                        this.method_5783(class_3417.field_20614, 0.8f, 1.0f);
                    }
                    if (currentTimer == 1) {
                        this.consumeBerry();
                    }
                }
            } else {
                int currentTimer = this.getEatingTimer();
                if (currentTimer > 0 && currentTimer <= 120 && this.isActivelyEating() && currentTimer % 40 == 0) {
                    this.createEatingParticles();
                }
            }
        } else if (this.getEatingTimer() > 0) {
            this.setEatingTimer(0);
            this.setActivelyEating(false);
        }
    }

    private void createEatingParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1799 berryStack = new class_1799((class_1935)class_1802.field_16998);
            class_2392 particleData = new class_2392(class_2398.field_11218, berryStack);
            float yaw = this.method_36454();
            double forwardX = -Math.sin(Math.toRadians(yaw)) * 0.6;
            double forwardZ = Math.cos(Math.toRadians(yaw)) * 0.6;
            class_243 mouthPos = this.method_19538().method_1031(forwardX, (double)this.method_17682() * 0.5, forwardZ);
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetY = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                serverLevel.method_14199((class_2394)particleData, mouthPos.field_1352 + offsetX, mouthPos.field_1351 + offsetY, mouthPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void consumeBerry() {
        this.createEatingParticles();
        this.method_5783(class_3417.field_18060, 1.0f, 1.0f);
        this.setMouthItem(class_1799.field_8037);
        this.setEatingTimer(0);
        this.setActivelyEating(false);
        this.method_6025(1.0f);
    }

    private void createStinkyParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            float red = 0.4f;
            float green = 0.6f;
            float blue = 0.3f;
            class_2390 dustOptions = new class_2390(new Vector3f(red, green, blue), 1.0f);
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.8;
                double offsetY = this.field_5974.method_43058() * 0.3 + 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.8;
                double velX = (this.field_5974.method_43058() - 0.5) * 0.02;
                double velY = this.field_5974.method_43058() * 0.05 + 0.02;
                double velZ = (this.field_5974.method_43058() - 0.5) * 0.02;
                serverLevel.method_14199((class_2394)dustOptions, this.method_23317() + offsetX, this.method_23318() + offsetY, this.method_23321() + offsetZ, 1, velX, velY, velZ, 0.0);
            }
        }
    }

    void dropMouthItem() {
        if (!this.getMouthItem().method_7960()) {
            this.method_5775(this.getMouthItem());
            this.setMouthItem(class_1799.field_8037);
            this.setEatingTimer(0);
            this.setActivelyEating(false);
        }
    }

    protected void pickUpItem(class_1542 itemEntity) {
        class_1799 itemstack = itemEntity.method_6983();
        if (this.canPickUpItem(itemstack)) {
            int itemCount = itemstack.method_7947();
            if (!this.getMouthItem().method_7960()) {
                this.dropMouthItem();
            }
            this.setMouthItem(new class_1799((class_1935)class_1802.field_16998, 1));
            this.method_6103((class_1297)itemEntity, 1);
            if (itemCount > 1) {
                itemstack.method_7934(1);
            } else {
                itemEntity.method_31472();
            }
            this.method_5783(class_3417.field_15197, 0.2f, ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public boolean canPickUpItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_16998) && this.getMouthItem().method_7960() && !this.isPlayingDead() && !this.method_6113() && (!this.method_6109() || !this.method_5765());
    }

    public static enum Variant implements class_3542
    {
        REGULAR(0, "regular"),
        LIGHT(1, "light"),
        DARK(2, "dark");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
            BY_ID = class_7995.method_47914(Variant::getId, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
        }
    }

    public class PlayDeadGoal
    extends class_1352 {
        private int playDeadTimer;
        private int particleTimer = 0;
        private static final int PLAY_DEAD_DURATION = 160;
        private static final int PLAY_DEAD_COOLDOWN_TIME = 100;
        private static final int PARTICLE_INTERVAL = 15;

        public PlayDeadGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            if (!OpossumEntity.this.getShouldPlayDead()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead() || OpossumEntity.this.getPlayDeadCooldown() > 0) {
                return false;
            }
            if (OpossumEntity.this.method_6113()) {
                return false;
            }
            return !OpossumEntity.this.method_6109() || !OpossumEntity.this.method_5765();
        }

        public boolean method_6266() {
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                return false;
            }
            return this.playDeadTimer > 0 && OpossumEntity.this.isPlayingDead();
        }

        public void method_6269() {
            this.playDeadTimer = 160;
            this.particleTimer = 0;
            OpossumEntity.this.setPlayingDead(true);
            OpossumEntity.this.setShouldPlayDead(false);
            OpossumEntity.this.method_5942().method_6340();
            OpossumEntity.this.method_18799(class_243.field_1353);
            if (!OpossumEntity.this.method_6109() && OpossumEntity.this.hasBabyPassengers()) {
                OpossumEntity.this.dismountBabies();
            }
            OpossumEntity.this.method_5980(null);
            OpossumEntity.this.setAggressive(false);
        }

        public void method_6270() {
            OpossumEntity.this.setPlayingDead(false);
            OpossumEntity.this.setPlayDeadCooldown(100);
            this.playDeadTimer = 0;
            this.particleTimer = 0;
        }

        public void method_6268() {
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                OpossumEntity.this.setPlayingDead(false);
                return;
            }
            if (this.playDeadTimer > 0) {
                --this.playDeadTimer;
                OpossumEntity.this.method_5942().method_6340();
                OpossumEntity.this.method_18799(class_243.field_1353);
                OpossumEntity.this.field_6212 = 0.0f;
                OpossumEntity.this.field_6227 = 0.0f;
                OpossumEntity.this.field_6250 = 0.0f;
                ++this.particleTimer;
                if (this.particleTimer >= 15) {
                    this.particleTimer = 0;
                    OpossumEntity.this.createStinkyParticles();
                }
            }
            if (this.playDeadTimer <= 0 && OpossumEntity.this.isPlayingDead()) {
                OpossumEntity.this.setPlayingDead(false);
            }
        }
    }

    public class OpossumEatBerriesGoal
    extends class_1367 {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public OpossumEatBerriesGoal(double speed, int range, int maxYDifference) {
            super((class_1314)OpossumEntity.this, speed, range, maxYDifference);
        }

        public double method_6291() {
            return 2.0;
        }

        public boolean method_6294() {
            return this.field_6517 % 100 == 0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            class_2680 blockstate = world.method_8320(pos);
            return blockstate.method_27852(class_2246.field_16999) && (Integer)blockstate.method_11654((class_2769)class_3830.field_17000) >= 2;
        }

        public void method_6268() {
            if (this.method_6295()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.method_6295() && OpossumEntity.this.method_6051().method_43057() < 0.05f) {
                OpossumEntity.this.method_5783(class_3417.field_18063, 1.0f, 1.0f);
            }
            super.method_6268();
        }

        protected void onReachedTarget() {
            class_2680 blockstate = OpossumEntity.this.method_37908().method_8320(this.field_6512);
            if (blockstate.method_27852(class_2246.field_16999)) {
                this.pickSweetBerries(blockstate);
            }
        }

        private void pickSweetBerries(class_2680 state) {
            int currentAge = (Integer)state.method_11654((class_2769)class_3830.field_17000);
            int berriesToDrop = 1 + OpossumEntity.this.method_37908().field_9229.method_43048(2) + (currentAge == 3 ? 1 : 0);
            class_1799 mouthItem = OpossumEntity.this.getMouthItem();
            if (mouthItem.method_7960()) {
                OpossumEntity.this.setMouthItem(new class_1799((class_1935)class_1802.field_16998));
            }
            if (berriesToDrop > 0) {
                class_2248.method_9577((class_1937)OpossumEntity.this.method_37908(), (class_2338)this.field_6512, (class_1799)new class_1799((class_1935)class_1802.field_16998, berriesToDrop));
            }
            OpossumEntity.this.method_5783(class_3417.field_17617, 1.0f, 1.0f);
            OpossumEntity.this.method_37908().method_8652(this.field_6512, (class_2680)state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean method_6264() {
            return !OpossumEntity.this.method_6113() && !OpossumEntity.this.isPlayingDead() && (!OpossumEntity.this.method_6109() || !OpossumEntity.this.method_5765()) && super.method_6264();
        }

        public void method_6269() {
            this.ticksWaited = 0;
            super.method_6269();
        }
    }

    public class OpossumSearchForItemsGoal
    extends class_1352 {
        public OpossumSearchForItemsGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!OpossumEntity.this.getMouthItem().method_7960()) {
                return false;
            }
            if (OpossumEntity.this.method_5968() != null || OpossumEntity.this.method_6065() != null) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead() || OpossumEntity.this.method_6113()) {
                return false;
            }
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                return false;
            }
            if (OpossumEntity.this.method_6051().method_43048(class_1352.method_38848((int)10)) != 0) {
                return false;
            }
            List list = OpossumEntity.this.method_37908().method_8390(class_1542.class, OpossumEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !list.isEmpty();
        }

        public void method_6268() {
            List list = OpossumEntity.this.method_37908().method_8390(class_1542.class, OpossumEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (OpossumEntity.this.getMouthItem().method_7960() && !list.isEmpty()) {
                class_1542 closest = (class_1542)list.get(0);
                double closestDistance = OpossumEntity.this.method_5858((class_1297)closest);
                for (class_1542 item : list) {
                    double distance = OpossumEntity.this.method_5858((class_1297)item);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closest = item;
                }
                if (closestDistance <= 2.25) {
                    OpossumEntity.this.pickUpItem(closest);
                } else {
                    OpossumEntity.this.method_5942().method_6337(closest.method_23317(), closest.method_23318(), closest.method_23321(), 1.2);
                }
            }
        }

        public void method_6269() {
            List list = OpossumEntity.this.method_37908().method_8390(class_1542.class, OpossumEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                class_1542 target = (class_1542)list.get(0);
                OpossumEntity.this.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), 1.2);
            }
        }
    }

    public class FollowAdultOpossumGoal
    extends class_1352 {
        private final OpossumEntity baby;
        private OpossumEntity targetAdult;
        private final double speedModifier;
        private final float stopDistance;
        private final float startDistance;
        private int timeToRecalcPath;

        public FollowAdultOpossumGoal(OpossumEntity baby, double speedModifier, float stopDistance, float startDistance) {
            this.baby = baby;
            this.speedModifier = speedModifier;
            this.stopDistance = stopDistance;
            this.startDistance = startDistance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (!this.baby.method_6109()) {
                return false;
            }
            if (this.baby.method_5765()) {
                return false;
            }
            if (this.baby.method_6113()) {
                return false;
            }
            OpossumEntity nearestAdult = this.findNearestAdult();
            if (nearestAdult == null) {
                return false;
            }
            double distance = this.baby.method_5739((class_1297)nearestAdult);
            if (distance < (double)this.startDistance) {
                this.targetAdult = nearestAdult;
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            if (this.targetAdult == null || !this.targetAdult.method_5805() || !this.baby.method_6109()) {
                return false;
            }
            if (this.baby.method_5765()) {
                return false;
            }
            if (this.baby.method_6113()) {
                return false;
            }
            double distance = this.baby.method_5739((class_1297)this.targetAdult);
            return distance < (double)this.startDistance * 1.5;
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
        }

        public void method_6270() {
            this.targetAdult = null;
            this.baby.method_5942().method_6340();
        }

        public void method_6268() {
            if (this.targetAdult == null) {
                return;
            }
            if (this.baby.method_6113()) {
                this.baby.method_5942().method_6340();
                return;
            }
            this.baby.method_5988().method_35111((class_1297)this.targetAdult);
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = class_1352.method_38848((int)10);
                double distance = this.baby.method_5739((class_1297)this.targetAdult);
                if (distance <= 2.5 && this.targetAdult.method_5818((class_1297)this.baby) && this.baby.canRideAdult() && !this.targetAdult.isPlayingDead()) {
                    this.baby.method_5873((class_1297)this.targetAdult, true);
                    this.baby.setHasRidden(true);
                    return;
                }
                if (distance > (double)this.stopDistance) {
                    this.baby.method_5942().method_6335((class_1297)this.targetAdult, this.speedModifier);
                } else {
                    this.baby.method_5942().method_6340();
                }
            }
        }

        private OpossumEntity findNearestAdult() {
            double closestDistance = Double.MAX_VALUE;
            OpossumEntity closestAdult = null;
            for (class_1297 entity : this.baby.method_37908().method_8333((class_1297)this.baby, this.baby.method_5829().method_1014((double)this.startDistance), e -> e instanceof OpossumEntity)) {
                double distance;
                OpossumEntity opossum;
                if (!(entity instanceof OpossumEntity) || (opossum = (OpossumEntity)entity).method_6109() || opossum == this.baby || !opossum.method_5805() || !((distance = (double)this.baby.method_5739((class_1297)opossum)) < closestDistance)) continue;
                closestDistance = distance;
                closestAdult = opossum;
            }
            return closestAdult;
        }
    }

    public class SleepGoal
    extends class_1352 {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = OpossumEntity.this.field_5974.method_43048(class_1352.method_38848((int)countdownTime));
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        public boolean method_6264() {
            boolean isStationary;
            if (OpossumEntity.this.method_5799()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead()) {
                return false;
            }
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                return false;
            }
            if (OpossumEntity.this.hasBabyPassengers()) {
                return false;
            }
            if (OpossumEntity.this.method_6113()) {
                return true;
            }
            boolean bl = isStationary = OpossumEntity.this.field_6212 == 0.0f && OpossumEntity.this.field_6227 == 0.0f && OpossumEntity.this.field_6250 == 0.0f;
            if (isStationary) {
                return this.canSleep();
            }
            return false;
        }

        public boolean method_6266() {
            if (OpossumEntity.this.method_5799()) {
                return false;
            }
            if (OpossumEntity.this.isPlayingDead()) {
                return false;
            }
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                return false;
            }
            if (OpossumEntity.this.hasBabyPassengers()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return OpossumEntity.this.method_37908().method_23886();
        }

        public void method_6270() {
            if (!OpossumEntity.this.method_6109() || !OpossumEntity.this.method_5765()) {
                OpossumEntity.this.setSleeping(false);
            }
            this.countdown = OpossumEntity.this.field_5974.method_43048(this.countdownTime);
        }

        public void method_6269() {
            if (!OpossumEntity.this.method_6109() || !OpossumEntity.this.method_5765()) {
                OpossumEntity.this.method_6100(false);
                OpossumEntity.this.setSleeping(true);
                OpossumEntity.this.method_5942().method_6340();
            }
        }

        public void method_6268() {
            if (OpossumEntity.this.method_6109() && OpossumEntity.this.method_5765()) {
                return;
            }
            if (!OpossumEntity.this.method_6109() && OpossumEntity.this.hasBabyPassengers()) {
                OpossumEntity.this.setSleeping(false);
                return;
            }
            if (OpossumEntity.this.method_6113()) {
                OpossumEntity.this.method_5942().method_6340();
            }
        }
    }
}

