/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreFloorTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreWallTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.curio.CuriosCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.FarmersCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigCraftBandolierCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigCraftLightCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigCraftUnlitCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigHardcoreCampfireCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigHardcoreStoveCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigLanternsUseFuelCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigOilcanCoalCondition;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigOilcanFatCondition;
import com.github.wolfiewaffle.hardcore_torches.event.PlayerEventHandler;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.init.BlockInit;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.loot.FatModifier;
import com.github.wolfiewaffle.hardcore_torches.loot.ReplaceTorchModifier;
import com.github.wolfiewaffle.hardcore_torches.loot.SetFuelLootFunction;
import com.github.wolfiewaffle.hardcore_torches.loot.TorchLootFunction;
import com.github.wolfiewaffle.hardcore_torches.recipe.DamageLightRecipe;
import com.github.wolfiewaffle.hardcore_torches.recipe.OilCanRecipe;
import com.github.wolfiewaffle.hardcore_torches.recipe.TorchRecipe;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.world.ReplaceAllBiomeModifier;
import com.github.wolfiewaffle.hardcore_torches.world.ReplaceAllFeature;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="hardcore_torches")
public class HardcoreTorches {
    private static ModContainer HCTcontainer;
    public static final String MOD_ID = "hardcore_torches";
    public static TorchGroup basicTorches;
    public static TorchGroup soulTorches;
    public static LanternGroup basicLanterns;
    public static LanternGroup soulLanterns;
    public static final TagKey<Item> MC_ANIMAL_FAT;
    public static final TagKey<Item> ALL_TORCH_ITEMS;
    public static final TagKey<Item> ACTIVE_TORCHES;
    public static final TagKey<Item> INACTIVE_TORCHES;
    public static final TagKey<Block> FREE_TORCH_LIGHT_BLOCKS;
    public static final TagKey<Item> FREE_TORCH_LIGHT_ITEMS;
    public static final TagKey<Item> DAMAGE_TORCH_LIGHT_ITEMS;
    public static final TagKey<Item> CONSUME_TORCH_LIGHT_ITEMS;
    public static final TagKey<Item> FREE_TORCH_EXTINGUISH_ITEMS;
    public static final TagKey<Item> DAMAGE_TORCH_EXTINGUISH_ITEMS;
    public static final TagKey<Item> CONSUME_TORCH_EXTINGUISH_ITEMS;
    public static final TagKey<Item> FREE_TORCH_SMOTHER_ITEMS;
    public static final TagKey<Item> DAMAGE_TORCH_SMOTHER_ITEMS;
    public static final TagKey<Item> CONSUME_TORCH_SMOTHER_ITEMS;
    public static final TagKey<Item> FREE_LANTERN_LIGHT_ITEMS;
    public static final TagKey<Item> DAMAGE_LANTERN_LIGHT_ITEMS;
    public static final TagKey<Item> CONSUME_LANTERN_LIGHT_ITEMS;
    public static final TagKey<Item> SOUL_ITEMS;
    public static final LootItemFunctionType HARDCORE_TORCH_LOOT_FUNCTION;
    public static final LootItemFunctionType SET_FUEL_LOOT_FUNCTION;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_DEFERRED_REGISTER;
    public static final DeferredHolder<RecipeType<?>, RecipeType<OilCanRecipe>> OIL_CAN_RECIPE;
    public static final DeferredHolder<RecipeType<?>, RecipeType<DamageLightRecipe>> DAMAGE_LIGHT_RECIPE;
    public static final DeferredHolder<RecipeType<?>, RecipeType<TorchRecipe>> TORCH_RECIPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_DEFERRED_REGISTER;
    private static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<OilCanRecipe>> OIL_CAN_RECIPE_SERIALIZER;
    private static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<DamageLightRecipe>> DAMAGE_LIGHT_RECIPE_SERIALIZER;
    private static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<TorchRecipe>> TORCH_RECIPE_SERIALIZER;
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MOD_CODEC_REGISTER;
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<FatModifier>> FAT_MOD_CODEC;
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<ReplaceTorchModifier>> REPLACE_TORCH_MOD_CODEC;
    private static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNC_REGISTER;
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<?>> TORCH_LOOT_FUNCTION_TYPE;
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<?>> SET_FUEL_FUNCTION_TYPE;
    private static final DeferredRegister<Feature<?>> FEATURE_REGISTER;
    private static final DeferredHolder<Feature<?>, ReplaceAllFeature> REPLACE_ALL_FEATURE;
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS;
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<ReplaceAllBiomeModifier>> REPLACE_ALL_MODIFIER;
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_SERIALIZERS;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigCraftUnlitCondition>> CONDITION_CRAFT_UNLIT;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigCraftLightCondition>> CONDITION_CRAFT_LIGHT;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigHardcoreCampfireCondition>> CONDITION_HARDCORE_CAMPFIRE;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigHardcoreStoveCondition>> CONDITION_HARDCORE_STOVE;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigLanternsUseFuelCondition>> CONDITION_LANTERNS_USE_FUEL;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigOilcanFatCondition>> CONDITION_OILCANS_USE_FAT;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigOilcanCoalCondition>> CONDITION_OILCANS_USE_COAL;
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<ConfigCraftBandolierCondition>> CONDITION_CRAFT_BANDOLIER;
    public static final DeferredRegister<DataComponentType<?>> DATA_TYPES;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> TYPE_FUEL;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> TYPE_TORCH_COUNT;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Holder<Item>>> TYPE_TORCH_TYPE;

    public HardcoreTorches(IEventBus modEventBus, ModContainer HCTcontainer) {
        HardcoreTorches.HCTcontainer = HCTcontainer;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::buildContents);
        modEventBus.addListener(this::registerCapabilities);
        NeoForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        if (ModList.get().isLoaded("amendments")) {
            AmendmentsCommonCompat.loadCompat();
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.loadCompat();
        }
        LOOT_MOD_CODEC_REGISTER.register(modEventBus);
        LOOT_FUNC_REGISTER.register(modEventBus);
        RECIPE_TYPE_DEFERRED_REGISTER.register(modEventBus);
        RECIPE_SERIALIZER_DEFERRED_REGISTER.register(modEventBus);
        FEATURE_REGISTER.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        CONDITION_SERIALIZERS.register(modEventBus);
        DATA_TYPES.register(modEventBus);
        Config.init(HCTcontainer);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        basicTorches.add((HardcoreFloorTorchBlock)BlockInit.LIT_TORCH.get());
        basicTorches.add((HardcoreWallTorchBlock)BlockInit.LIT_WALL_TORCH.get());
        basicTorches.add((HardcoreFloorTorchBlock)BlockInit.UNLIT_TORCH.get());
        basicTorches.add((HardcoreWallTorchBlock)BlockInit.UNLIT_WALL_TORCH.get());
        basicTorches.add((HardcoreFloorTorchBlock)BlockInit.SMOLDERING_TORCH.get());
        basicTorches.add((HardcoreWallTorchBlock)BlockInit.SMOLDERING_WALL_TORCH.get());
        basicTorches.add((HardcoreFloorTorchBlock)BlockInit.BURNT_TORCH.get());
        basicTorches.add((HardcoreWallTorchBlock)BlockInit.BURNT_WALL_TORCH.get());
        basicLanterns.add((AbstractLanternBlock)BlockInit.LIT_LANTERN.get());
        basicLanterns.add((AbstractLanternBlock)BlockInit.UNLIT_LANTERN.get());
        soulLanterns.add((AbstractLanternBlock)BlockInit.LIT_SOUL_LANTERN.get());
        soulLanterns.add((AbstractLanternBlock)BlockInit.UNLIT_SOUL_LANTERN.get());
        soulTorches.add((HardcoreFloorTorchBlock)BlockInit.LIT_SOUL_TORCH.get());
        soulTorches.add((HardcoreWallTorchBlock)BlockInit.LIT_WALL_SOUL_TORCH.get());
        soulTorches.add((HardcoreFloorTorchBlock)BlockInit.UNLIT_SOUL_TORCH.get());
        soulTorches.add((HardcoreWallTorchBlock)BlockInit.UNLIT_WALL_SOUL_TORCH.get());
        if (ModList.get().isLoaded("amendments")) {
            AmendmentsCommonCompat.loadData();
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.loadData();
        }
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCommonCompat.attachCapabilities(event);
        }
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ItemInit.OIL_CAN.get());
            event.accept(OilCanItem.setFuel(new ItemStack((ItemLike)ItemInit.OIL_CAN.get()), (Integer)Config.maxCanFuel.get()));
            if (((Boolean)Config.showBandolier.get()).booleanValue()) {
                event.accept((ItemLike)ItemInit.BANDOLIER.get());
            }
            event.accept((ItemLike)ItemInit.FIRE_STARTER.get());
            event.accept((ItemLike)ItemInit.ANIMAL_FAT.get());
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)ItemInit.LIT_TORCH.get());
            event.accept((ItemLike)ItemInit.UNLIT_TORCH.get());
            event.accept((ItemLike)ItemInit.SMOLDERING_TORCH.get());
            event.accept((ItemLike)ItemInit.BURNT_TORCH.get());
            event.accept((ItemLike)ItemInit.LIT_SOUL_TORCH.get());
            event.accept((ItemLike)ItemInit.UNLIT_SOUL_TORCH.get());
            event.accept((ItemLike)ItemInit.LIT_LANTERN.get());
            event.accept((ItemLike)ItemInit.UNLIT_LANTERN.get());
            event.accept((ItemLike)ItemInit.LIT_SOUL_LANTERN.get());
            event.accept((ItemLike)ItemInit.UNLIT_SOUL_LANTERN.get());
            event.accept((ItemLike)ItemInit.UNLIT_CAMPFIRE.get());
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.creativeTab(event);
        }
    }

    static {
        basicTorches = new TorchGroup("basic");
        soulTorches = new TorchGroup("soul");
        basicLanterns = new LanternGroup("basic");
        soulLanterns = new LanternGroup("soul");
        MC_ANIMAL_FAT = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:animal_fat"));
        ALL_TORCH_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:torches"));
        ACTIVE_TORCHES = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:active_torches"));
        INACTIVE_TORCHES = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:inactive_torches"));
        FREE_TORCH_LIGHT_BLOCKS = BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:free_torch_light_blocks"));
        FREE_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:free_torch_light_items"));
        DAMAGE_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:damage_torch_light_items"));
        CONSUME_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:consume_torch_light_items"));
        FREE_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:free_torch_extinguish_items"));
        DAMAGE_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:damage_torch_extinguish_items"));
        CONSUME_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:consume_torch_extinguish_items"));
        FREE_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:free_torch_smother_items"));
        DAMAGE_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:damage_torch_smother_items"));
        CONSUME_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:consume_torch_smother_items"));
        FREE_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:free_lantern_light_items"));
        DAMAGE_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:damage_lantern_light_items"));
        CONSUME_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:consume_lantern_light_items"));
        SOUL_ITEMS = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"hardcore_torches:soul_attunement_items"));
        HARDCORE_TORCH_LOOT_FUNCTION = new LootItemFunctionType(TorchLootFunction.CODEC);
        SET_FUEL_LOOT_FUNCTION = new LootItemFunctionType(SetFuelLootFunction.CODEC);
        RECIPE_TYPE_DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)MOD_ID);
        OIL_CAN_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("oil_can", () -> new RecipeType<OilCanRecipe>(){});
        DAMAGE_LIGHT_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("damage_light", () -> new RecipeType<DamageLightRecipe>(){});
        TORCH_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("torch", () -> new RecipeType<TorchRecipe>(){});
        RECIPE_SERIALIZER_DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)MOD_ID);
        OIL_CAN_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("oil_can", OilCanRecipe.Serializer::new);
        DAMAGE_LIGHT_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("damage_light", DamageLightRecipe.Serializer::new);
        TORCH_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("torch", TorchRecipe.Serializer::new);
        LOOT_MOD_CODEC_REGISTER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MOD_ID);
        FAT_MOD_CODEC = LOOT_MOD_CODEC_REGISTER.register("fat_modifier", () -> FatModifier.CODEC);
        REPLACE_TORCH_MOD_CODEC = LOOT_MOD_CODEC_REGISTER.register("replace_torches_in_containers", () -> ReplaceTorchModifier.CODEC);
        LOOT_FUNC_REGISTER = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)MOD_ID);
        TORCH_LOOT_FUNCTION_TYPE = LOOT_FUNC_REGISTER.register("torch", () -> HARDCORE_TORCH_LOOT_FUNCTION);
        SET_FUEL_FUNCTION_TYPE = LOOT_FUNC_REGISTER.register("set_damage", () -> SET_FUEL_LOOT_FUNCTION);
        FEATURE_REGISTER = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)MOD_ID);
        REPLACE_ALL_FEATURE = FEATURE_REGISTER.register("replace_all", () -> new ReplaceAllFeature(NoneFeatureConfiguration.CODEC.stable()));
        BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        REPLACE_ALL_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("replace_all_modifier", () -> ReplaceAllBiomeModifier.CODEC);
        CONDITION_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)MOD_ID);
        CONDITION_CRAFT_UNLIT = CONDITION_SERIALIZERS.register(ConfigCraftUnlitCondition.NAME.getPath(), () -> ConfigCraftUnlitCondition.CODEC);
        CONDITION_CRAFT_LIGHT = CONDITION_SERIALIZERS.register(ConfigCraftLightCondition.NAME.getPath(), () -> ConfigCraftLightCondition.CODEC);
        CONDITION_HARDCORE_CAMPFIRE = CONDITION_SERIALIZERS.register(ConfigHardcoreCampfireCondition.NAME.getPath(), () -> ConfigHardcoreCampfireCondition.CODEC);
        CONDITION_HARDCORE_STOVE = CONDITION_SERIALIZERS.register(ConfigHardcoreStoveCondition.NAME.getPath(), () -> ConfigHardcoreStoveCondition.CODEC);
        CONDITION_LANTERNS_USE_FUEL = CONDITION_SERIALIZERS.register(ConfigLanternsUseFuelCondition.NAME.getPath(), () -> ConfigLanternsUseFuelCondition.CODEC);
        CONDITION_OILCANS_USE_FAT = CONDITION_SERIALIZERS.register(ConfigOilcanFatCondition.NAME.getPath(), () -> ConfigOilcanFatCondition.CODEC);
        CONDITION_OILCANS_USE_COAL = CONDITION_SERIALIZERS.register(ConfigOilcanCoalCondition.NAME.getPath(), () -> ConfigOilcanCoalCondition.CODEC);
        CONDITION_CRAFT_BANDOLIER = CONDITION_SERIALIZERS.register(ConfigCraftBandolierCondition.NAME.getPath(), () -> ConfigCraftBandolierCondition.CODEC);
        DATA_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)MOD_ID);
        TYPE_FUEL = DATA_TYPES.register("fuel", () -> DataTypes.FUEL);
        TYPE_TORCH_COUNT = DATA_TYPES.register("torch_count", () -> DataTypes.TORCH_COUNT);
        TYPE_TORCH_TYPE = DATA_TYPES.register("torch_type", () -> DataTypes.TORCH_TYPE);
    }
}

