/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.TorchBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.SoulAttunement;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHardcoreTorchBlock
extends BaseEntityBlock
implements IFuelBlock,
EntityBlock {
    public SimpleParticleType fireParticle;
    public SimpleParticleType smokeParticle;
    public ETorchState burnState;
    public TorchGroup group;
    public static final BlockEntityTicker<TorchBlockEntity> TICKER = (level, pos, state, be) -> be.tick();
    public IntSupplier maxFuel;

    public AbstractHardcoreTorchBlock(BlockBehaviour.Properties prop, SimpleParticleType fireParticle, SimpleParticleType smokeParticle, ETorchState burnState, TorchGroup group, IntSupplier maxFuel) {
        super(prop);
        this.fireParticle = fireParticle;
        this.smokeParticle = smokeParticle;
        this.burnState = burnState;
        this.group = group;
        this.maxFuel = maxFuel;
    }

    public abstract boolean isWall();

    @Override
    public boolean isSoulVariant() {
        return this.group == HardcoreTorches.soulTorches;
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        return this.burnState != ETorchState.BURNT && this.burnState != ETorchState.LIT;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.burnState == ETorchState.LIT) {
            if (this.attemptUseItem(stack, player, hand, ETorchState.UNLIT)) {
                this.extinguish(world, pos, state, true);
                player.swing(hand);
                return ItemInteractionResult.SUCCESS;
            }
            if (this.attemptUseItem(stack, player, hand, ETorchState.SMOLDERING)) {
                this.smother(world, pos, state);
                player.swing(hand);
                return ItemInteractionResult.SUCCESS;
            }
        }
        BlockEntity be = world.getBlockEntity(pos);
        if ((this.burnState == ETorchState.SMOLDERING || this.burnState == ETorchState.UNLIT) && this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
            if (this.isSoulVariant()) {
                if (be instanceof IFuelBlockEntity) {
                    IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)be;
                    if (fuelBlockEntity.getFuel() > 0) {
                        this.light(world, pos);
                    } else {
                        player.displayClientMessage((Component)Component.literal((String)"Needs XP from an Amethyst Shard"), true);
                    }
                }
            } else {
                this.light(world, pos);
            }
            player.swing(hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)Config.handUnlightTorch.get()).booleanValue() && (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) && !TorchTools.canLight(stack.getItem(), this.defaultBlockState())) {
            this.extinguish(world, pos, state, true);
            return ItemInteractionResult.SUCCESS;
        }
        if (this.isSoulVariant()) {
            return SoulAttunement.soulAttune(world, pos, (IFuelBlockEntity)be, (IFuelBlock)state.getBlock(), player, hand);
        }
        if (((Boolean)Config.torchesUseCan.get()).booleanValue() && this.burnState != ETorchState.BURNT && !world.isClientSide && OilCanItem.fuelBlock((IFuelBlockEntity)be, world, stack)) {
            world.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be == null) {
            return InteractionResult.PASS;
        }
        if (be.getType() != null && be.getType() == BlockEntityInit.TORCH_BLOCK_ENTITY.get() && !world.isClientSide && ((Boolean)Config.fuelMessage.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.literal((String)("Fuel: " + ((TorchBlockEntity)be).getFuel())), true);
        }
        if (((Boolean)Config.handUnlightTorch.get()).booleanValue() && (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING)) {
            this.extinguish(world, pos, state, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        BlockEntity be = world.getBlockEntity(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.getItem() instanceof TorchItem) {
            int fuel = TorchItem.getFuel(itemStack);
            if (fuel == 0) {
                ((FuelBlockEntity)be).setFuel(this.getMaxFuel());
            } else {
                ((FuelBlockEntity)be).setFuel(fuel);
            }
        }
    }

    public static boolean isLightItem(ItemStack stack) {
        if (stack.is(HardcoreTorches.FREE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.is(HardcoreTorches.DAMAGE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        return stack.is(HardcoreTorches.CONSUME_TORCH_LIGHT_ITEMS);
    }

    public void smother(Level world, BlockPos pos, BlockState state) {
        if (this.group == HardcoreTorches.soulTorches) {
            this.extinguish(world, pos, state, true);
        } else if (!world.isClientSide) {
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.SMOLDERING);
        }
    }

    public void burnOut(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (this.group == HardcoreTorches.soulTorches) {
            this.extinguish(world, pos, state, true);
        } else if (!world.isClientSide) {
            if (playSound) {
                world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.BURNT);
        }
    }

    @Override
    public void light(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!world.isClientSide) {
            world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.5f, 1.2f);
            TorchTools.displayParticle(ParticleTypes.LAVA, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.FLAME, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.LIT);
        }
    }

    public void changeTorch(Level world, BlockPos pos, BlockState curState, ETorchState newType) {
        BlockState newState = this.isWall() ? this.group.getWallTorch(newType).withPropertiesOf(curState) : this.group.getStandingTorch(newType).withPropertiesOf(curState);
        int newFuel = 0;
        if (world.getBlockEntity(pos) != null) {
            newFuel = ((FuelBlockEntity)world.getBlockEntity(pos)).getFuel();
        }
        world.setBlockAndUpdate(pos, newState);
        if (world.getBlockEntity(pos) != null) {
            ((FuelBlockEntity)world.getBlockEntity(pos)).setFuel(newFuel);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) {
            return type == BlockEntityInit.TORCH_BLOCK_ENTITY.get() ? (level, pos, blockState, be) -> ((TorchBlockEntity)be).tick() : super.getTicker(world, state, type);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof AbstractHardcoreTorchBlock) {
            AbstractHardcoreTorchBlock torch = (AbstractHardcoreTorchBlock)block;
            if (torch.burnState != ETorchState.BURNT) {
                TorchBlockEntity be = new TorchBlockEntity(pos, state);
                be.setFuel(this.getMaxFuel());
                return be;
            }
        }
        return null;
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        if (this.group == HardcoreTorches.soulTorches) {
            this.extinguish(world, pos, state, true);
        } else {
            this.burnOut(world, pos, state, false);
        }
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (!world.isClientSide) {
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.LARGE_SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.SMOKE, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.UNLIT);
        }
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        return new ItemStack((ItemLike)world.getBlockState(pos).getBlock());
    }

    @Override
    public ItemInteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        this.attemptUseItem(stack, player, hand, ETorchState.LIT);
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public boolean isLit() {
        return this.burnState == ETorchState.LIT;
    }
}

