/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import com.mojang.serialization.MapCodec;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HardcoreFloorTorchBlock
extends AbstractHardcoreTorchBlock {
    public static final MapCodec<HardcoreFloorTorchBlock> CODEC = null;
    protected static final int AABB_STANDING_OFFSET = 2;
    protected static final VoxelShape AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public HardcoreFloorTorchBlock(BlockBehaviour.Properties prop, SimpleParticleType fireParticle, SimpleParticleType smokeParticle, ETorchState burnState, TorchGroup group, IntSupplier maxFuel) {
        super(prop, fireParticle, smokeParticle, burnState, group, maxFuel);
    }

    @Override
    public boolean isWall() {
        return false;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        TorchTools.displayParticle(this.fireParticle, state, world, pos);
        TorchTools.displayParticle(this.smokeParticle, state, world, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected BlockState updateShape(BlockState state1, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return direction == Direction.DOWN && !this.canSurvive(state1, (LevelReader)world, pos1) ? Blocks.AIR.defaultBlockState() : super.updateShape(state1, direction, state2, world, pos1, pos2);
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return HardcoreFloorTorchBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

