/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.block.HardcoreCampfire;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HardcoreCampfireBlockEntity
extends CampfireBlockEntity {
    protected int fuel = 0;

    public HardcoreCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        CampfireBlockEntity.particleTick((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    public static void cookTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        if (entity.fuel <= 0) {
            Block block = state.getBlock();
            if (block instanceof HardcoreCampfire) {
                HardcoreCampfire campfire = (HardcoreCampfire)block;
                campfire.outOfFuel(world, pos, state);
            }
        } else {
            --entity.fuel;
        }
        HardcoreCampfireBlockEntity.takeFuelItems(world, pos, entity);
        CampfireBlockEntity.cookTick((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    public static void cooldownTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        HardcoreCampfireBlockEntity.takeFuelItems(world, pos, entity);
        CampfireBlockEntity.cooldownTick((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    private static void takeFuelItems(Level world, BlockPos pos, HardcoreCampfireBlockEntity entity) {
        for (ItemEntity itementity : HardcoreCampfireBlockEntity.getItemsAtAndAbove(world, pos)) {
            FuelResult result;
            int burnTime = itementity.getItem().getBurnTime(RecipeType.SMELTING);
            if (burnTime <= 0 || (result = entity.setFuel((int)((double)entity.getFuel() + (double)burnTime * (Double)Config.campfireFuelFactor.get()))) == FuelResult.FULL) continue;
            itementity.kill();
            world.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (result != FuelResult.SOME_WASTE || !HardcoreCampfireBlockEntity.isLit(world, pos)) continue;
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.5f);
        }
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get();
    }

    public int getFuel() {
        return this.fuel;
    }

    public static boolean isLit(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.hasProperty((Property)CampfireBlock.LIT)) {
            return (Boolean)state.getValue((Property)CampfireBlock.LIT);
        }
        return false;
    }

    public FuelResult setFuel(int newValue) {
        if (this.fuel >= (Integer)Config.campfireMaxFuel.get()) {
            return FuelResult.FULL;
        }
        this.fuel = newValue;
        if (this.fuel > (Integer)Config.campfireMaxFuel.get()) {
            this.fuel = (Integer)Config.campfireMaxFuel.get();
            return FuelResult.SOME_WASTE;
        }
        return FuelResult.HAD_SPACE;
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level world, BlockPos pos) {
        VoxelShape INSIDE = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        VoxelShape ABOVE = Block.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
        VoxelShape BOTH = Shapes.or((VoxelShape)INSIDE, (VoxelShape)ABOVE);
        return BOTH.toAabbs().stream().flatMap(aabb -> world.getEntitiesOfClass(ItemEntity.class, aabb.move((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt != null) {
            super.loadAdditional(nbt, registries);
            this.fuel = nbt.getInt("Fuel");
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    private static enum FuelResult {
        HAD_SPACE,
        SOME_WASTE,
        FULL;

    }
}

