/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TorchBlockEntity
extends FuelBlockEntity {
    public TorchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TORCH_BLOCK_ENTITY.get(), pos, state);
        Block block = state.getBlock();
        if (block instanceof AbstractHardcoreTorchBlock) {
            this.fuel = ((AbstractHardcoreTorchBlock)state.getBlock()).maxFuel.getAsInt();
        }
    }

    @Override
    public int getMaxFuel() {
        return (Integer)Config.defaultTorchFuel.get();
    }

    public void tick() {
        Level world = this.getLevel();
        if (!world.isClientSide) {
            BlockPos pos = this.getBlockPos();
            BlockState state = this.getBlockState();
            if (!(state.getBlock() instanceof AbstractHardcoreTorchBlock)) {
                return;
            }
            if (((AbstractHardcoreTorchBlock)state.getBlock()).burnState == ETorchState.LIT) {
                this.tickLit(world, pos, state);
            } else if (((AbstractHardcoreTorchBlock)state.getBlock()).burnState == ETorchState.SMOLDERING) {
                this.tickSmoldering(world, pos, state);
            }
        }
    }

    private void tickLit(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)Config.torchesRain.get()).booleanValue() && world.isRainingAt(pos) && random.nextInt(200) == 0) {
            if (((Boolean)Config.torchesSmolder.get()).booleanValue()) {
                ((AbstractHardcoreTorchBlock)world.getBlockState(pos).getBlock()).smother(world, pos, state);
            } else {
                ((AbstractHardcoreTorchBlock)world.getBlockState(pos).getBlock()).extinguish(world, pos, state, true);
            }
        }
        if (this.fuel >= 0) {
            this.changeFuel(-1);
        }
        this.setChanged();
    }

    private void tickSmoldering(Level world, BlockPos pos, BlockState state) {
        if (random.nextInt(3) == 0 && this.fuel > 0) {
            --this.fuel;
            if (this.fuel <= 0) {
                ((AbstractHardcoreTorchBlock)world.getBlockState(pos).getBlock()).burnOut(world, pos, state, false);
            }
        }
        this.setChanged();
    }
}

