/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.amendments;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.HardcoreWallLantern;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WallLanternBlockEntity
extends WallLanternBlockTile
implements IFuelBlockEntity {
    public LanternGroup group = HardcoreTorches.basicLanterns;
    public boolean isLit = true;
    protected int fuel = (Integer)Config.startingLanternFuel.get();
    protected static Random random = new Random();

    public WallLanternBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)AmendmentsCommonCompat.WALL_LANTERN_BLOCK_ENTITY.get();
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public int getMaxFuel() {
        return ((HardcoreWallLantern)this.getBlockState().getBlock()).getMaxFuel();
    }

    @Override
    public boolean canAddFuel() {
        return this.getFuel() < this.getMaxFuel();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, WallLanternBlockEntity tile) {
        if (!world.isClientSide) {
            if (tile.getFuel() >= 0 && ((HardcoreWallLantern)world.getBlockState((BlockPos)pos).getBlock()).isLit) {
                Block block;
                tile.setFuel(tile.getFuel() - 1);
                if (tile.getFuel() <= 0 && (block = tile.getBlockState().getBlock()) instanceof HardcoreWallLantern) {
                    HardcoreWallLantern lantern = (HardcoreWallLantern)block;
                    lantern.extinguish(tile.getLevel(), tile.getBlockPos(), tile.getBlockState(), true);
                }
            }
            tile.setChanged();
        }
    }

    @Override
    public void setFuel(int newValue) {
        this.fuel = Math.min(this.getMaxFuel(), Math.max(0, newValue));
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt != null) {
            super.loadAdditional(nbt, registries);
            this.fuel = nbt.getInt("Fuel");
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }
}

