/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight;

import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.FarmersCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.HardcoreStoveBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import vectorwing.farmersdelight.common.block.StoveBlock;

public class HardcoreStove
extends StoveBlock {
    public HardcoreStove(BlockBehaviour.Properties properties, boolean lit) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be = world.getBlockEntity(pos);
        Item heldItem = stack.getItem();
        if (be instanceof HardcoreStoveBlockEntity) {
            HardcoreStoveBlockEntity stove = (HardcoreStoveBlockEntity)be;
            int burnTime = stack.getBurnTime(RecipeType.SMELTING);
            if (burnTime > 0) {
                if (stove.canAcceptFuel(burnTime)) {
                    stack.shrink(1);
                    stove.addFuel((int)((double)burnTime * (Double)Config.campfireFuelFactor.get()));
                    world.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (stove.fuel <= 0 && (heldItem == Items.FLINT_AND_STEEL || heldItem == Items.FIRE_CHARGE)) {
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)"Right click with combustible items to add fuel!"), true);
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)FarmersCommonCompat.STOVE_BLOCK_ENTITY.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (Boolean)state.getValue((Property)LIT) != false ? HardcoreStove.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)FarmersCommonCompat.STOVE_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.isClientSide ? HardcoreStoveBlockEntity::animationTick : HardcoreStoveBlockEntity::serverTick)) : null;
    }
}

