/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BandolierItem
extends Item {
    public BandolierItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BandolierItem.getTorchCount(stack) < BandolierItem.getMaxCount() || BandolierItem.getFuel(stack) < BandolierItem.getMaxFuel();
    }

    public int getBarWidth(ItemStack stack) {
        int count = BandolierItem.getTorchCount(stack);
        int max = BandolierItem.getMaxCount();
        return max != 0 ? Math.round(13.0f - (float)(max - count) * 13.0f / (float)max) : 0;
    }

    public int getBarColor(ItemStack stack) {
        float maxFuel = (float)BandolierItem.getTorchCount(stack) * (float)((Integer)Config.defaultTorchFuel.get()).intValue();
        float f = Math.max(0.0f, (maxFuel - (maxFuel - (float)BandolierItem.getFuel(stack))) / maxFuel);
        Item item = BandolierItem.getTorchItemOrAir(stack);
        if (item instanceof TorchItem) {
            TorchItem torch = (TorchItem)item;
            if (torch.burnState == ETorchState.BURNT) {
                return Mth.hsvToRgb((float)0.5f, (float)0.5f, (float)0.5f);
            }
        }
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.literal((String)"Right-click to add"));
        tooltipComponents.add((Component)Component.literal((String)"or remove torches"));
        Item item = BandolierItem.getTorchItemOrAir(stack);
        if (item instanceof TorchItem) {
            tooltipComponents.add((Component)Component.literal((String)(BandolierItem.getTorchCount(stack) + " * ")).append((Component)Component.translatable((String)item.getDescriptionId())).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.literal((String)((int)Math.ceil((float)BandolierItem.getFuel(stack) / ((float)BandolierItem.getTorchCount(stack) * (float)((Integer)Config.defaultTorchFuel.get()).intValue()) * 100.0f) + "% Fuel")).withStyle(ChatFormatting.GRAY));
        }
    }

    public static ItemStack getNextTorchOrEmpty(ItemStack bandolierStack, boolean justOne) {
        ItemStack resultStack = ItemStack.EMPTY;
        if (bandolierStack.has(DataTypes.TORCH_TYPE) && bandolierStack.has(DataTypes.TORCH_COUNT)) {
            int count = justOne ? 1 : Math.min((Integer)bandolierStack.get(DataTypes.TORCH_COUNT), BandolierItem.getTorchItemOrAir(bandolierStack).getDefaultMaxStackSize());
            resultStack = new ItemStack((ItemLike)BandolierItem.getTorchItemOrAir(bandolierStack), count);
            if (resultStack.getItem() instanceof TorchItem) {
                resultStack = TorchItem.setFuel(resultStack, (Integer)bandolierStack.getOrDefault(DataTypes.FUEL, (Object)0) / (Integer)bandolierStack.get(DataTypes.TORCH_COUNT));
            }
        }
        return resultStack;
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BandolierItem)) {
            return 0;
        }
        return (Integer)stack.getOrDefault(DataTypes.FUEL, (Object)0);
    }

    public static Item getTorchItemOrAir(ItemStack stack) {
        Item item = stack.getItem();
        Item output = Items.AIR;
        if (item instanceof BandolierItem) {
            if (BandolierItem.getTorchCount(stack) == 0) {
                return output;
            }
            if (stack.has(DataTypes.TORCH_TYPE)) {
                return (Item)((Holder)stack.get(DataTypes.TORCH_TYPE)).value();
            }
        }
        return output;
    }

    private static int getMaxFuel() {
        return (Integer)Config.bandolierMaxTorches.get() * (Integer)Config.defaultTorchFuel.get();
    }

    private static int getMaxCount() {
        return (Integer)Config.bandolierMaxTorches.get();
    }

    private static int getTorchCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataTypes.TORCH_COUNT, (Object)0);
    }

    public boolean overrideOtherStackedOnMe(ItemStack selfStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            if (otherStack.isEmpty()) {
                ItemStack takenTorch = BandolierItem.getNextTorchOrEmpty(selfStack, false);
                if (takenTorch != ItemStack.EMPTY) {
                    access.set(takenTorch);
                    BandolierItem.deleteTorches(selfStack, takenTorch.getCount());
                    return true;
                }
            } else {
                Item takenTorch = otherStack.getItem();
                if (takenTorch instanceof TorchItem) {
                    TorchItem otherTorch = (TorchItem)takenTorch;
                    boolean compatible = false;
                    Item item = BandolierItem.getTorchItemOrAir(selfStack);
                    if (item instanceof TorchItem) {
                        TorchItem bandoTorch = (TorchItem)item;
                        if (bandoTorch.burnState == ETorchState.BURNT && otherTorch.burnState == ETorchState.BURNT) {
                            compatible = true;
                        }
                        if (bandoTorch.burnState != ETorchState.BURNT && otherTorch.burnState != ETorchState.BURNT) {
                            compatible = true;
                        }
                    } else {
                        compatible = true;
                    }
                    if (compatible) {
                        int i = BandolierItem.add(selfStack, otherStack);
                        if (i > 0) {
                            this.playInsertSound((Entity)player);
                            otherStack.shrink(i);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void replaceStack(ItemStack bandolierStack, ItemStack insertedStack) {
        Item item = insertedStack.getItem();
        if (item instanceof TorchItem) {
            TorchItem torch = (TorchItem)item;
            item = bandolierStack.getItem();
            if (item instanceof BandolierItem) {
                BandolierItem bandolier = (BandolierItem)item;
                if (!insertedStack.isEmpty()) {
                    bandolierStack.set(DataTypes.TORCH_TYPE, (Object)torch.builtInRegistryHolder());
                    bandolierStack.set(DataTypes.TORCH_COUNT, (Object)insertedStack.getCount());
                    bandolierStack.set(DataTypes.FUEL, (Object)(TorchItem.getFuel(insertedStack) * insertedStack.getCount()));
                }
            }
        }
    }

    public static ItemStack getTickedBandolier(ItemStack stack) {
        Item item;
        if (!stack.has(DataTypes.TORCH_COUNT)) {
            return stack;
        }
        int count = (Integer)stack.getOrDefault(DataTypes.TORCH_COUNT, (Object)0);
        ItemStack heldStack = BandolierItem.getNextTorchOrEmpty(stack, true);
        heldStack = heldStack.copyWithCount(count);
        if (!heldStack.isEmpty() && (item = heldStack.getItem()) instanceof TorchItem) {
            TorchItem torch = (TorchItem)item;
            heldStack = TorchItem.getTickedStack(heldStack);
            BandolierItem.replaceStack(stack, heldStack);
        }
        return stack;
    }

    private static int add(ItemStack bandolierStack, ItemStack insertedStack) {
        Item item = insertedStack.getItem();
        if (item instanceof TorchItem) {
            TorchItem torchItem = (TorchItem)item;
            if (!insertedStack.isEmpty() && torchItem.canFitInsideContainerItems()) {
                if (!bandolierStack.has(DataTypes.TORCH_TYPE)) {
                    bandolierStack.set(DataTypes.TORCH_TYPE, (Object)torchItem.builtInRegistryHolder());
                }
                int existingCount = BandolierItem.getTorchCount(bandolierStack);
                int insertCount = Math.min(insertedStack.getCount(), BandolierItem.getMaxCount() - existingCount);
                if (insertCount == 0) {
                    return 0;
                }
                int fuel = TorchItem.getFuel(insertedStack);
                bandolierStack.set(DataTypes.TORCH_COUNT, (Object)(insertCount + existingCount));
                bandolierStack.set(DataTypes.FUEL, (Object)(BandolierItem.getFuel(bandolierStack) + insertCount * fuel));
                return insertCount;
            }
        }
        return 0;
    }

    public static void empty(ItemStack bandolierStack) {
        bandolierStack.remove(DataTypes.FUEL);
        bandolierStack.remove(DataTypes.TORCH_TYPE);
        bandolierStack.remove(DataTypes.TORCH_COUNT);
    }

    public static void deleteOneTorch(ItemStack bandolierStack, ItemStack torchStack) {
        if (torchStack.getItem() instanceof TorchItem) {
            int fuel = TorchItem.getFuel(torchStack);
            int count = BandolierItem.getTorchCount(bandolierStack) - 1;
            if (count > 0) {
                bandolierStack.set(DataTypes.TORCH_COUNT, (Object)count);
                bandolierStack.set(DataTypes.FUEL, (Object)(BandolierItem.getFuel(bandolierStack) - fuel));
            } else {
                BandolierItem.empty(bandolierStack);
            }
        }
    }

    public static void deleteTorches(ItemStack bandolierStack, int removeCount) {
        ItemStack removeStack = BandolierItem.getNextTorchOrEmpty(bandolierStack, true);
        if (removeStack.isEmpty()) {
            return;
        }
        if (removeStack.getItem() instanceof TorchItem) {
            int fuel = TorchItem.getFuel(removeStack) * removeCount;
            int newCount = BandolierItem.getTorchCount(bandolierStack) - removeCount;
            if (newCount <= 0) {
                BandolierItem.empty(bandolierStack);
            } else {
                bandolierStack.set(DataTypes.FUEL, (Object)(BandolierItem.getFuel(bandolierStack) - fuel));
                bandolierStack.set(DataTypes.TORCH_COUNT, (Object)newCount);
            }
        }
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        ItemStack stack1 = oldStack.copy();
        ItemStack stack2 = newStack.copy();
        stack1.remove(DataTypes.FUEL);
        stack2.remove(DataTypes.FUEL);
        return super.shouldCauseReequipAnimation(stack1, stack2, slotChanged);
    }
}

