/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import java.awt.Color;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OilCanItem
extends Item {
    public OilCanItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        int maxFuel = (Integer)Config.maxCanFuel.get();
        int fuel = OilCanItem.getFuel(stack);
        if (maxFuel != 0) {
            return Math.round(13.0f - (float)(maxFuel - fuel) * 13.0f / (float)maxFuel);
        }
        return 0;
    }

    public int getBarColor(ItemStack stack) {
        return Color.HSBtoRGB(0.5f, 1.0f, 1.0f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        ItemStack stack1 = oldStack.copy();
        ItemStack stack2 = newStack.copy();
        stack1.remove(DataTypes.FUEL);
        stack2.remove(DataTypes.FUEL);
        return super.shouldCauseReequipAnimation(stack1, stack2, slotChanged);
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof OilCanItem)) {
            return 0;
        }
        return (Integer)stack.getOrDefault(DataTypes.FUEL, (Object)0);
    }

    public static ItemStack setFuel(ItemStack stack, int fuel) {
        if (stack.getItem() instanceof OilCanItem) {
            stack.set(DataTypes.FUEL, (Object)Math.max(0, Math.min((Integer)Config.maxCanFuel.get(), fuel)));
        }
        return stack;
    }

    public static ItemStack addFuel(ItemStack stack, int amount) {
        if (stack.getItem() instanceof OilCanItem) {
            int fuel = (Integer)stack.getOrDefault(DataTypes.FUEL, (Object)0);
            fuel = Math.min((Integer)Config.maxCanFuel.get(), Math.max(0, fuel + amount));
            stack.set(DataTypes.FUEL, (Object)fuel);
        }
        return stack;
    }

    public static boolean fuelBlock(IFuelBlockEntity be, Level world, ItemStack stack) {
        if (!world.isClientSide) {
            int maxFromCan = 0;
            int maxFuel = be.getMaxFuel();
            maxFromCan = Math.max(0, maxFuel - be.getFuel());
            int taken = Math.min(maxFromCan, OilCanItem.getFuel(stack));
            OilCanItem.addFuel(stack, -taken);
            be.setFuel(be.getFuel() + taken);
            return taken > 0;
        }
        return false;
    }
}

