/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.HardcoreTorches;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.component.DataTypes;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import java.awt.Color;
import java.util.Random;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TorchItem
extends StandingAndWallBlockItem {
    public ETorchState burnState;
    TorchGroup torchGroup;
    public IntSupplier maxFuel;
    protected static Random random = new Random();

    public TorchItem(Block floorBlock, Block wallBlock, Item.Properties properties, Direction direction) {
        super(floorBlock, wallBlock, properties, direction);
        this.burnState = ((AbstractHardcoreTorchBlock)floorBlock).burnState;
        this.torchGroup = ((AbstractHardcoreTorchBlock)floorBlock).group;
        this.maxFuel = ((AbstractHardcoreTorchBlock)floorBlock).maxFuel;
    }

    public boolean isLit() {
        return this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING;
    }

    public static ItemStack getTickedStack(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof TorchItem) {
            TorchItem torch = (TorchItem)item;
            int fuel = TorchItem.getFuel(stack);
            if (torch.burnState == ETorchState.LIT) {
                --fuel;
            } else if (torch.burnState == ETorchState.SMOLDERING && random.nextInt(3) == 0) {
                --fuel;
            }
            fuel = Math.max(0, fuel);
            if (fuel <= 0) {
                stack = TorchItem.stateStack(stack, ETorchState.BURNT);
            }
            stack = TorchItem.setFuel(stack, fuel);
        }
        return stack;
    }

    public int getTotalFuel(ItemStack stack) {
        return TorchItem.getFuel(stack) * stack.getCount();
    }

    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    public boolean isBarVisible(ItemStack stack) {
        int fuel = TorchItem.getFuel(stack);
        return fuel > 0 && fuel < this.getMaxFuel();
    }

    public int getBarWidth(ItemStack stack) {
        int fuel = TorchItem.getFuel(stack);
        int max = this.getMaxFuel();
        if (max != 0) {
            return Math.round(13.0f - (float)(max - fuel) * 13.0f / (float)max);
        }
        return 0;
    }

    public int getBarColor(ItemStack stack) {
        return Color.HSBtoRGB(0.5f, 1.0f, 1.0f);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack cStack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (cStack.getItem() instanceof TorchItem) {
            ETorchState torchState = ((TorchItem)cStack.getItem()).burnState;
            BlockState blockState = world.getBlockState(pos);
            Block block = blockState.getBlock();
            if ((torchState == ETorchState.UNLIT || torchState == ETorchState.SMOLDERING) && blockState.is(HardcoreTorches.FREE_TORCH_LIGHT_BLOCKS)) {
                if (blockState.hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    return super.useOn(context);
                }
                Player player = context.getPlayer();
                if (player != null && !world.isClientSide) {
                    player.setItemInHand(context.getHand(), TorchItem.stateStack(cStack, ETorchState.LIT));
                }
                if (!world.isClientSide) {
                    world.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.5f, 1.2f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public static ItemStack stateStack(ItemStack inputStack, ETorchState newState) {
        ItemStack outputStack = ItemStack.EMPTY;
        if (inputStack.getItem() instanceof BlockItem && inputStack.getItem() instanceof TorchItem) {
            AbstractHardcoreTorchBlock newBlock = (AbstractHardcoreTorchBlock)((BlockItem)inputStack.getItem()).getBlock();
            TorchItem newItem = (TorchItem)newBlock.group.getStandingTorch(newState).asItem();
            outputStack = TorchItem.changedCopy(inputStack, (Item)newItem);
            if (newState == ETorchState.BURNT) {
                outputStack = new ItemStack((ItemLike)newItem, outputStack.getCount());
            }
        }
        return outputStack;
    }

    public static ItemStack changedCopy(ItemStack stack, Item replacementItem) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = new ItemStack((ItemLike)replacementItem, stack.getCount());
        if (stack.getComponents() != null && !stack.getComponents().isEmpty()) {
            itemStack.applyComponents(stack.copy().getComponents());
        }
        return itemStack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        ItemStack stack1 = oldStack.copy();
        ItemStack stack2 = newStack.copy();
        stack1.remove(DataTypes.FUEL);
        stack2.remove(DataTypes.FUEL);
        return !stack1.getComponents().equals((Object)stack2.getComponents());
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof TorchItem)) {
            return 0;
        }
        return (Integer)stack.getOrDefault(DataTypes.FUEL, (Object)((TorchItem)item).getMaxFuel());
    }

    public static ItemStack setFuel(ItemStack stack, int amount) {
        if (stack.getItem() instanceof TorchItem) {
            stack.set(DataTypes.FUEL, (Object)Math.max(0, Math.min((Integer)Config.defaultTorchFuel.get(), amount)));
        }
        return stack;
    }

    public static boolean sameTorchGroup(TorchItem item1, TorchItem item2) {
        return item1.torchGroup == item2.torchGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ItemStack addFuel(ItemStack stack, Level world, int amount) {
        Item item = stack.getItem();
        int maxFuel = item instanceof TorchItem ? ((TorchItem)item).getMaxFuel() : 0;
        if (!(stack.getItem() instanceof TorchItem)) return stack;
        if (world.isClientSide) return stack;
        int fuel = (Integer)stack.getOrDefault(DataTypes.FUEL, (Object)maxFuel);
        if ((fuel += amount) <= 0) {
            if ((Integer)Config.burntDrop.get() == 0) {
                return TorchItem.stateStack(stack, ETorchState.BURNT);
            }
            if ((Integer)Config.burntDrop.get() != 1) return ItemStack.EMPTY;
            return new ItemStack((ItemLike)Items.STICK, stack.getCount());
        }
        if (fuel > maxFuel) {
            fuel = maxFuel;
        }
        stack.set(DataTypes.FUEL, (Object)fuel);
        return stack;
    }

    public boolean overrideOtherStackedOnMe(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!slot.allowModification(player) || !(otherStack.getItem() instanceof TorchItem) || otherStack.isEmpty()) {
            return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (!TorchItem.sameTorchGroup((TorchItem)slotStack.getItem(), (TorchItem)otherStack.getItem())) {
            return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (slotStack.getCount() < slotStack.getMaxStackSize()) {
            return this.addToLitStack(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }

    public boolean lightCursorStack(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!(otherStack.getItem() instanceof TorchItem)) {
            return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        Item newItem = ((TorchItem)otherStack.getItem()).torchGroup.getStandingTorch(ETorchState.LIT).asItem();
        ItemStack newStack = TorchItem.changedCopy(otherStack, newItem);
        slotAccess.set(new ItemStack((ItemLike)Items.STONE));
        return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }

    public boolean addToLitStack(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        TorchItem slotTorch = (TorchItem)slotStack.getItem();
        TorchItem cursorTorch = (TorchItem)otherStack.getItem();
        if (slotTorch.burnState == ETorchState.BURNT || cursorTorch.burnState == ETorchState.BURNT) {
            return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (slotTorch.burnState == ETorchState.UNLIT) {
            return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        int max = slotStack.getMaxStackSize();
        int usedCount = clickAction == ClickAction.PRIMARY ? otherStack.getCount() : 1;
        int remainder = Math.max(0, usedCount - (max - slotStack.getCount()));
        int addedNew = usedCount - remainder;
        int stack1Fuel = TorchItem.getFuel(slotStack) * slotStack.getCount();
        int stack2Fuel = TorchItem.getFuel(otherStack) * addedNew;
        int totalFuel = stack1Fuel + stack2Fuel;
        if (addedNew > 0) {
            slotStack.grow(addedNew);
            slotStack.set(DataTypes.FUEL, (Object)(totalFuel / slotStack.getCount()));
            otherStack.setCount(otherStack.getCount() - addedNew);
            return true;
        }
        return super.overrideOtherStackedOnMe(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }
}

