/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.loot;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class FatModifier
extends LootModifier {
    private final List<Integer> choices;
    public static final MapCodec<FatModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions), (App)Codec.INT.listOf().fieldOf("choices").forGetter(FatModifier::getChoices)).apply((Applicative)instance, FatModifier::new));

    public FatModifier(LootItemCondition[] conditions, List<Integer> choices) {
        super(conditions);
        this.choices = choices;
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Config.animalsDropFat.get()).booleanValue()) {
            return generatedLoot;
        }
        Random random = new Random();
        int num = this.choices.get(random.nextInt(this.choices.size()));
        if (num > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ItemInit.ANIMAL_FAT.get(), num));
        }
        return generatedLoot;
    }

    public List<Integer> getChoices() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Lists.newArrayList(this.choices);
        return list;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

