/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DamageLightRecipe
extends ShapelessRecipe {
    final boolean damageItem;

    public DamageLightRecipe(String group, ItemStack result, NonNullList<Ingredient> recipeItems, boolean damageItem) {
        super(group, CraftingBookCategory.MISC, result, recipeItems);
        this.damageItem = damageItem;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int fuel = 0;
        ItemStack resultStack = this.getResultItem(registries).copy();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack = input.getItem(i);
            Item item = itemstack.getItem();
            if (!(item instanceof TorchItem)) continue;
            TorchItem torch = (TorchItem)item;
            if (torch.burnState != ETorchState.UNLIT && torch.burnState != ETorchState.SMOLDERING) continue;
            fuel = TorchItem.getFuel(itemstack);
        }
        if (resultStack.getItem() instanceof TorchItem) {
            return TorchItem.setFuel(resultStack, fuel);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList nonnulllist = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack result;
            ItemStack item = input.getItem(i);
            if (!this.damageItem) {
                result = item.copyWithCount(1);
                Item item2 = item.getItem();
                if (item2 instanceof TorchItem) {
                    TorchItem torch = (TorchItem)item2;
                    if (torch.burnState != ETorchState.LIT) continue;
                    nonnulllist.set(i, (Object)result);
                    continue;
                }
                nonnulllist.set(i, (Object)result);
                continue;
            }
            if (item.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!item.isDamageableItem() || !this.damageItem || item.getDamageValue() == item.getMaxDamage() - 1) continue;
            result = item.copy();
            result.setDamageValue(item.getDamageValue() + 1);
            nonnulllist.set(i, (Object)result);
        }
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<DamageLightRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.parse((String)"hardcore_torches:damage_light");
        private static final MapCodec<DamageLightRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(rec -> rec.getGroup()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(rec -> rec.getResultItem(null).copyWithCount(((Integer)Config.torchCraftAmount.get()).intValue())), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(rec -> {
            Object[] aingredient = (Ingredient[])rec.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(rec -> rec.getIngredients()), (App)Codec.BOOL.fieldOf("damage").forGetter(rec -> rec.damageItem)).apply((Applicative)builder, DamageLightRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DamageLightRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<DamageLightRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DamageLightRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DamageLightRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int i = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean damageItem = buffer.readBoolean();
            return new DamageLightRecipe(group, result, (NonNullList<Ingredient>)ingredients, damageItem);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, DamageLightRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
            buffer.writeBoolean(recipe.damageItem);
        }
    }
}

