/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class OilCanRecipe
extends ShapelessRecipe {
    final int fuelAmount;

    public OilCanRecipe(String group, ItemStack result, NonNullList<Ingredient> recipeItems, int fuelAmount) {
        super(group, CraftingBookCategory.EQUIPMENT, result, recipeItems);
        this.fuelAmount = fuelAmount;
    }

    public boolean matches(CraftingInput input, Level level) {
        StackedContents recipeMatcher = new StackedContents();
        Item fuelItem = null;
        int i = 0;
        for (int j = 0; j < input.size(); ++j) {
            ItemStack itemStack = input.getItem(j);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof OilCanItem) {
                recipeMatcher.accountStack(itemStack, 1);
                ++i;
                continue;
            }
            if (fuelItem == null) {
                recipeMatcher.accountStack(itemStack, 1);
                ++i;
                fuelItem = itemStack.getItem();
                continue;
            }
            if (fuelItem == itemStack.getItem()) continue;
            recipeMatcher.accountStack(itemStack, 1);
            ++i;
        }
        boolean match = recipeMatcher.canCraft((Recipe)this, null);
        return i == this.getIngredients().size() && match;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int startFuel = 0;
        int addFuel = 0;
        ItemStack resultStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack = input.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem() instanceof OilCanItem) {
                OilCanItem can = (OilCanItem)itemstack.getItem();
                startFuel = OilCanItem.getFuel(itemstack);
                resultStack = itemstack;
                continue;
            }
            addFuel = (int)((double)addFuel + (double)this.fuelAmount * (Double)Config.oilRecipeMultiplier.get());
        }
        if (resultStack.getItem() instanceof OilCanItem) {
            return OilCanItem.setFuel(resultStack.copy(), startFuel + addFuel);
        }
        return ItemStack.EMPTY;
    }

    public static class Serializer
    implements RecipeSerializer<OilCanRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.parse((String)"hardcore_torches:oil_can");
        private static final MapCodec<OilCanRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(rec -> rec.getGroup()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(rec -> rec.getResultItem(null).copyWithCount(((Integer)Config.torchCraftAmount.get()).intValue())), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(rec -> {
            Object[] aingredient = (Ingredient[])rec.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(rec -> rec.getIngredients()), (App)Codec.INT.fieldOf("fuel").forGetter(rec -> rec.fuelAmount)).apply((Applicative)builder, OilCanRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, OilCanRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<OilCanRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OilCanRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static OilCanRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int i = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int fuel = buffer.readVarInt();
            return new OilCanRecipe(group, result, (NonNullList<Ingredient>)ingredients, fuel);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, OilCanRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
            buffer.writeInt(recipe.fuelAmount);
        }
    }
}

