/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class TorchRecipe
extends ShapedRecipe {
    ShapedRecipePattern pattern;

    public TorchRecipe(String group, ShapedRecipePattern pattern, ItemStack result) {
        super(group, CraftingBookCategory.EQUIPMENT, pattern, result.copyWithCount(((Integer)Config.torchCraftAmount.get()).intValue()));
        this.pattern = pattern;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack resultStack = this.getResultItem(registries).copy();
        resultStack.setCount(((Integer)Config.torchCraftAmount.get()).intValue());
        return resultStack;
    }

    public static class Serializer
    implements RecipeSerializer<TorchRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.parse((String)"hardcore_torches:torch");
        public static final MapCodec<TorchRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(rec -> rec.getGroup()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(rec -> rec.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(rec -> rec.getResultItem(null).copyWithCount(((Integer)Config.torchCraftAmount.get()).intValue()))).apply((Applicative)builder, TorchRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TorchRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TorchRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TorchRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static TorchRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            ShapedRecipePattern shapedRecipePattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack resultStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new TorchRecipe(group, shapedRecipePattern, resultStack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, TorchRecipe torchRecipe) {
            buffer.writeUtf(torchRecipe.getGroup());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)torchRecipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)torchRecipe.getResultItem(null));
        }
    }
}

