/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.blockentity.HardcoreCampfireBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class HardcoreCampfire
extends CampfireBlock
implements IFuelBlock {
    public HardcoreCampfire(boolean p_51236_, int p_51237_, BlockBehaviour.Properties p_51238_) {
        super(p_51236_, p_51237_, p_51238_);
    }

    public BlockState m_5573_(BlockPlaceContext p_51240_) {
        BlockPos blockpos;
        Level levelaccessor = p_51240_.m_43725_();
        boolean flag = levelaccessor.m_6425_(blockpos = p_51240_.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(this.m_51323_(levelaccessor.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_51230_, (Comparable)p_51240_.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof FlintAndSteelItem) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                return super.m_6227_(state, world, pos, player, hand, hit);
            }
            if (!world.f_46443_) {
                BlockEntity blockEntity;
                HardcoreCampfire campfire;
                Block block = state.m_60734_();
                if (block instanceof HardcoreCampfire && !(campfire = (HardcoreCampfire)block).canLight(world, pos)) {
                    if (campfire.getFuel(world, pos) <= 0) {
                        return this.needsFuel(player);
                    }
                } else if (CampfireBlock.m_51321_((BlockState)state) && (blockEntity = world.m_7702_(pos)) instanceof HardcoreCampfireBlockEntity) {
                    HardcoreCampfireBlockEntity campfire2 = (HardcoreCampfireBlockEntity)blockEntity;
                    if (this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        this.light(world, pos, state);
                        player.m_6674_(hand);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.CONSUME;
        }
        if (this.isValidStack(stack, this.getFreeLightItems(), this.getDamageLightItems(), this.getConsumeLightItems())) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                return super.m_6227_(state, world, pos, player, hand, hit);
            }
            if (!world.f_46443_) {
                if (this.getFuel(world, pos) <= 0) {
                    return this.needsFuel(player);
                }
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof HardcoreCampfireBlockEntity) {
                    HardcoreCampfireBlockEntity campfire = (HardcoreCampfireBlockEntity)blockEntity;
                    if (this.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        this.light(world, pos, state);
                        player.m_6674_(hand);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private boolean m_51323_(BlockState p_51324_) {
        return p_51324_.m_60713_(Blocks.f_50335_);
    }

    public static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? p_50760_ : 0;
    }

    @Override
    public int getMaxFuel() {
        return (Integer)Config.campfireMaxFuel.get();
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        BlockState newState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        world.m_46597_(pos, newState);
    }

    public void light(Level world, BlockPos pos, BlockState state) {
        BlockState newState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true));
        world.m_46597_(pos, newState);
        world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        HardcoreCampfireBlockEntity campfire;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof HardcoreCampfireBlockEntity && (campfire = (HardcoreCampfireBlockEntity)blockEntity).getFuel() <= 0) {
            return false;
        }
        return HardcoreCampfire.m_51321_((BlockState)world.m_8055_(pos));
    }

    public int getFuel(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof HardcoreCampfireBlockEntity) {
            HardcoreCampfireBlockEntity campfire = (HardcoreCampfireBlockEntity)blockEntity;
            return campfire.getFuel();
        }
        return 0;
    }

    public InteractionResult needsFuel(Player player) {
        player.m_5661_((Component)Component.m_237113_((String)"Drop combustible items on top to add fuel!"), true);
        return InteractionResult.CONSUME;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HardcoreCampfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.f_46443_) {
            return (Boolean)state.m_61143_((Property)f_51227_) != false ? HardcoreCampfire.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::clientTick) : null;
        }
        return (Boolean)state.m_61143_((Property)f_51227_) != false ? HardcoreCampfire.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::cookTick) : HardcoreCampfire.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get()), HardcoreCampfireBlockEntity::cooldownTick);
    }

    @Override
    public boolean isSoulVariant() {
        return false;
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        return new ItemStack((ItemLike)world.m_8055_(pos).m_60734_());
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        this.outOfFuel(world, pos, state);
    }

    @Override
    public void light(Level world, BlockPos pos) {
    }

    @Override
    public InteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    @Override
    public boolean isLit() {
        return false;
    }
}

