/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TorchBlockEntity
extends FuelBlockEntity {
    public TorchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TORCH_BLOCK_ENTITY.get(), pos, state);
        Block block = state.m_60734_();
        if (block instanceof AbstractHardcoreTorchBlock) {
            this.fuel = ((AbstractHardcoreTorchBlock)state.m_60734_()).maxFuel.getAsInt();
        }
    }

    @Override
    public int getMaxFuel() {
        return (Integer)Config.defaultTorchFuel.get();
    }

    public void tick() {
        Level world = this.m_58904_();
        if (!world.f_46443_) {
            BlockPos pos = this.m_58899_();
            BlockState state = this.m_58900_();
            if (!(state.m_60734_() instanceof AbstractHardcoreTorchBlock)) {
                return;
            }
            if (((AbstractHardcoreTorchBlock)state.m_60734_()).burnState == ETorchState.LIT) {
                this.tickLit(world, pos, state);
            } else if (((AbstractHardcoreTorchBlock)state.m_60734_()).burnState == ETorchState.SMOLDERING) {
                this.tickSmoldering(world, pos, state);
            }
        }
    }

    private void tickLit(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)Config.torchesRain.get()).booleanValue() && world.m_46758_(pos) && random.nextInt(200) == 0) {
            if (((Boolean)Config.torchesSmolder.get()).booleanValue()) {
                ((AbstractHardcoreTorchBlock)world.m_8055_(pos).m_60734_()).smother(world, pos, state);
            } else {
                ((AbstractHardcoreTorchBlock)world.m_8055_(pos).m_60734_()).extinguish(world, pos, state, true);
            }
        }
        if (this.fuel >= 0) {
            this.changeFuel(-1);
        }
        this.m_6596_();
    }

    private void tickSmoldering(Level world, BlockPos pos, BlockState state) {
        if (random.nextInt(3) == 0 && this.fuel > 0) {
            --this.fuel;
            if (this.fuel <= 0) {
                ((AbstractHardcoreTorchBlock)world.m_8055_(pos).m_60734_()).burnOut(world, pos, state, false);
            }
        }
        this.m_6596_();
    }
}

