/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.amendments;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.WallLanternBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.item.LanternItem;
import com.github.wolfiewaffle.hardcore_torches.util.BlockStateTools;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.LanternTools;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.common.tile.SwayingBlockTile;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class HardcoreWallLantern
extends WallLanternBlock
implements IFuelBlock {
    private LanternGroup group;
    boolean isLit;
    public IntSupplier maxFuel;
    private HardcoreWallLantern litVariant;
    private HardcoreWallLantern unlitVariant;
    private Block regularLantern;

    public HardcoreWallLantern(BlockBehaviour.Properties properties, boolean isLit, LanternGroup group, IntSupplier maxFuel, Block regularLantern) {
        super(properties);
        this.group = group;
        this.isLit = isLit;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(isLit)));
        this.regularLantern = regularLantern;
        this.maxFuel = maxFuel;
    }

    public void setVariants(HardcoreWallLantern lit, HardcoreWallLantern unlit) {
        this.litVariant = lit;
        this.unlitVariant = unlit;
    }

    @Override
    public boolean isSoulVariant() {
        return this.group == MainMod.soulLanterns;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return LanternTools.interactLantern(state, world, pos, player, hand);
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)this.group.getLanternBlock(this.isLit).m_5456_());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof WallLanternBlockEntity) {
            WallLanternBlockEntity lantern = (WallLanternBlockEntity)blockEntity;
            int remainingFuel = lantern.getFuel();
            if (!this.isLit || remainingFuel < lantern.getMaxFuel()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("Fuel", remainingFuel);
                stack.m_41751_(nbt);
            }
        }
        return stack;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        BlockEntity be = world.m_7702_(pos);
        if (be != null && be instanceof WallLanternBlockEntity && itemStack.m_41720_() instanceof LanternItem) {
            int fuel = LanternItem.getFuel(itemStack);
            ((WallLanternBlockEntity)be).setFuel(fuel);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        WallLanternBlockEntity te = new WallLanternBlockEntity(pos, state);
        te.isLit = this.isLit;
        te.group = this.group;
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return Utils.getTicker(type, (BlockEntityType)((BlockEntityType)AmendmentsCommonCompat.WALL_LANTERN_BLOCK_ENTITY.get()), (BlockEntityTicker)(world.f_46443_ ? SwayingBlockTile::clientTick : WallLanternBlockEntity::tick));
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        this.extinguish(world, pos, state, true);
    }

    @Override
    public InteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        return LanternTools.basicAttemptLight(world, pos, player, stack, hand);
    }

    @Override
    public boolean isLit() {
        return this.isLit;
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        if (this.isLit) {
            return false;
        }
        return ((WallLanternBlockEntity)world.m_7702_(pos)).getFuel() > 0 && !this.isLit;
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (!world.f_46443_) {
            if (playSound) {
                world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
        }
        if (world.m_7702_(pos) != null && world.m_7702_(pos) instanceof WallLanternBlockEntity) {
            int newFuel = ((WallLanternBlockEntity)world.m_7702_(pos)).getFuel();
            BlockState oldState = world.m_8055_(pos);
            world.m_7731_(pos, (BlockState)BlockStateTools.changeBlock(oldState, (Block)this.unlitVariant).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            ((WallLanternBlockEntity)world.m_7702_(pos)).setFuel(newFuel);
            ((WallLanternBlockEntity)world.m_7702_(pos)).setHeldBlock(this.unlitVariant.regularLantern.m_49966_());
        }
    }

    @Override
    public void light(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (world.m_7702_(pos) != null && world.m_7702_(pos) instanceof WallLanternBlockEntity) {
            int newFuel = ((WallLanternBlockEntity)world.m_7702_(pos)).getFuel();
            BlockState oldState = world.m_8055_(pos);
            world.m_7731_(pos, (BlockState)BlockStateTools.changeBlock(oldState, (Block)this.litVariant).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            ((WallLanternBlockEntity)world.m_7702_(pos)).setFuel(newFuel);
            ((WallLanternBlockEntity)world.m_7702_(pos)).setHeldBlock(this.litVariant.regularLantern.m_49966_());
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        ItemStack stack = new ItemStack((ItemLike)this.group.getLanternBlock(this.isLit));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (blockEntity != null && blockEntity instanceof IFuelBlockEntity) {
            IFuelBlockEntity lantern = (IFuelBlockEntity)blockEntity;
            int remainingFuel = lantern.getFuel();
            if (!this.isLit || remainingFuel < lantern.getMaxFuel()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("Fuel", remainingFuel);
                stack.m_41751_(nbt);
            }
        }
        stacks.add(stack);
        return stacks;
    }
}

