/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.amendments;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.HardcoreWallLantern;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WallLanternBlockEntity
extends WallLanternBlockTile
implements IFuelBlockEntity {
    public LanternGroup group = MainMod.basicLanterns;
    public boolean isLit = true;
    protected int fuel = (Integer)Config.startingLanternFuel.get();
    protected static Random random = new Random();

    public WallLanternBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)AmendmentsCommonCompat.WALL_LANTERN_BLOCK_ENTITY.get();
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public int getMaxFuel() {
        return ((HardcoreWallLantern)this.m_58900_().m_60734_()).getMaxFuel();
    }

    @Override
    public boolean canAddFuel() {
        return this.getFuel() < this.getMaxFuel();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, WallLanternBlockEntity tile) {
        if (!world.f_46443_) {
            if (tile.getFuel() >= 0 && ((HardcoreWallLantern)world.m_8055_((BlockPos)pos).m_60734_()).isLit) {
                Block block;
                tile.setFuel(tile.getFuel() - 1);
                if (tile.getFuel() <= 0 && (block = tile.m_58900_().m_60734_()) instanceof HardcoreWallLantern) {
                    HardcoreWallLantern lantern = (HardcoreWallLantern)block;
                    lantern.extinguish(tile.m_58904_(), tile.m_58899_(), tile.m_58900_(), true);
                }
            }
            tile.m_6596_();
        }
    }

    @Override
    public void setFuel(int newValue) {
        this.fuel = Math.min(this.getMaxFuel(), Math.max(0, newValue));
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt != null) {
            super.m_142466_(nbt);
            this.fuel = nbt.m_128451_("Fuel");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }
}

