/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractLanternBlock;
import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.curio.LanternCurioProvider;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import java.awt.Color;
import java.util.function.IntSupplier;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class LanternItem
extends BlockItem {
    public static Capability<ICurio> CURIO_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICurio>(){});
    public boolean isLit;
    public IntSupplier maxFuel;
    private AbstractLanternBlock lanternBlock;

    public LanternItem(Block block, Item.Properties properties) {
        super(block, properties);
        this.isLit = ((AbstractLanternBlock)block).isLit;
        this.maxFuel = ((AbstractLanternBlock)block).maxFuel;
        if (block instanceof AbstractLanternBlock) {
            this.lanternBlock = (AbstractLanternBlock)block;
        }
    }

    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        if (ModList.get().isLoaded("amendments")) {
            if (context.m_7058_()) {
                return super.m_5965_(context);
            }
            if (context.m_43719_() != Direction.DOWN && context.m_43719_() != Direction.UP) {
                BlockState state = this.lanternBlock.group == MainMod.basicLanterns ? (this.lanternBlock.isLit ? ((Block)AmendmentsCommonCompat.LIT_WALL_LANTERN.get()).m_49966_() : ((Block)AmendmentsCommonCompat.UNLIT_WALL_LANTERN.get()).m_49966_()) : (this.lanternBlock.isLit ? ((Block)AmendmentsCommonCompat.LIT_WALL_SOUL_LANTERN.get()).m_49966_() : ((Block)AmendmentsCommonCompat.UNLIT_WALL_SOUL_LANTERN.get()).m_49966_());
                state = (BlockState)state.m_61124_((Property)WallLanternBlock.FACING, (Comparable)context.m_43719_());
                BlockPos pos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
                boolean canSurvive = context.m_43725_().m_8055_(pos).m_60783_((BlockGetter)context.m_43725_(), pos, context.m_43719_());
                if (canSurvive) {
                    return state;
                }
                return null;
            }
        }
        return super.m_5965_(context);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return ModList.get().isLoaded("curios") ? new LanternCurioProvider(stack) : null;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int fuel = LanternItem.getFuel(stack);
        int max = this.getMaxFuel();
        return max != 0 ? Math.round(13.0f - (float)(max - fuel) * 13.0f / (float)max) : 0;
    }

    public int m_142159_(ItemStack stack) {
        return Color.HSBtoRGB(0.5f, 1.0f, 1.0f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        CompoundTag oldNbt = null;
        CompoundTag newNbt = null;
        if (oldStack.m_41783_() != null) {
            oldNbt = oldStack.m_41783_().m_6426_();
            oldNbt.m_128473_("Fuel");
        }
        if (newStack.m_41783_() != null) {
            newNbt = newStack.m_41783_().m_6426_();
            newNbt.m_128473_("Fuel");
        }
        if (oldNbt == null && newNbt != null) {
            return true;
        }
        if (oldNbt != null && newNbt == null) {
            return true;
        }
        return oldNbt == null && newNbt == null ? false : oldNbt.equals(null);
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof LanternItem)) {
            return 0;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Fuel")) {
            return nbt.m_128451_("Fuel");
        }
        LanternItem lanternItem = (LanternItem)item;
        int startingFuel = (Integer)Config.startingLanternFuel.get();
        if (lanternItem.lanternBlock.group == MainMod.soulLanterns) {
            startingFuel = 0;
        }
        return lanternItem.isLit ? lanternItem.getMaxFuel() : startingFuel;
    }

    public static ItemStack addFuel(ItemStack stack, Level world, int amount) {
        Item item = stack.m_41720_();
        int maxFuel = item instanceof LanternItem ? ((LanternItem)item).getMaxFuel() : 0;
        if (stack.m_41720_() instanceof LanternItem && !world.f_46443_) {
            int fuel;
            LanternItem lanternItem = (LanternItem)item;
            CompoundTag nbt = stack.m_41783_();
            int n = fuel = lanternItem.isLit ? maxFuel : 0;
            if (nbt != null) {
                fuel = nbt.m_128451_("Fuel");
            } else {
                nbt = new CompoundTag();
            }
            if ((fuel += amount) <= 0) {
                stack = LanternItem.stateStack(stack, false);
            } else {
                if (fuel > maxFuel) {
                    fuel = maxFuel;
                }
                nbt.m_128405_("Fuel", fuel);
                stack.m_41751_(nbt);
            }
        }
        return stack;
    }

    public static ItemStack stateStack(ItemStack inputStack, boolean isLit) {
        ItemStack outputStack = ItemStack.f_41583_;
        if (inputStack.m_41720_() instanceof BlockItem && inputStack.m_41720_() instanceof LanternItem) {
            LanternItem newItem = (LanternItem)((LanternItem)inputStack.m_41720_()).lanternBlock.group.getLanternBlock(isLit).m_5456_();
            outputStack = new ItemStack((ItemLike)newItem, inputStack.m_41613_());
            if (inputStack.m_41783_() != null) {
                outputStack.m_41751_(inputStack.m_41783_().m_6426_());
            }
        }
        return outputStack;
    }
}

