/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DamageLightRecipe
extends ShapelessRecipe {
    final boolean damageItem;

    public DamageLightRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> recipeItems, int damageItem) {
        super(id, group, CraftingBookCategory.MISC, result, recipeItems);
        this.damageItem = damageItem == 1;
    }

    public ItemStack m_5874_(CraftingContainer grid, RegistryAccess registryAccess) {
        int fuel = 0;
        ItemStack resultStack = this.m_8043_(registryAccess).m_41777_();
        for (int i = 0; i < grid.m_6643_(); ++i) {
            ItemStack itemstack = grid.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof TorchItem)) continue;
            fuel = TorchItem.getFuel(itemstack);
        }
        if (resultStack.m_41720_() instanceof TorchItem) {
            return TorchItem.setFuel(resultStack, fuel);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack result;
            ItemStack item = container.m_8020_(i);
            if (!this.damageItem) {
                result = item.m_41777_();
                if (item.m_41720_() instanceof TorchItem) continue;
                nonnulllist.set(i, (Object)result);
                continue;
            }
            if (item.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!item.m_41763_() || !this.damageItem || item.m_41773_() == item.m_41776_() - 1) continue;
            result = item.m_41777_();
            result.m_41721_(item.m_41773_() + 1);
            nonnulllist.set(i, (Object)result);
        }
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<DamageLightRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("hardcore_torches", "damage_light");

        public DamageLightRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(resourceLocation, json);
            boolean damageItem = json.get("damage").getAsBoolean();
            return new DamageLightRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(null), (NonNullList<Ingredient>)recipe.m_7527_(), damageItem ? 1 : 0);
        }

        public DamageLightRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_8005_(resourceLocation, friendlyByteBuf);
            int damageItem = friendlyByteBuf.m_130242_();
            return new DamageLightRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(null), (NonNullList<Ingredient>)recipe.m_7527_(), damageItem);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, DamageLightRecipe damageLightRecipe) {
            ShapelessRecipe rec = new ShapelessRecipe(damageLightRecipe.m_6423_(), damageLightRecipe.m_6076_(), CraftingBookCategory.EQUIPMENT, damageLightRecipe.m_8043_(null), damageLightRecipe.m_7527_());
            ShapelessRecipe.Serializer.f_44077_.m_6178_(friendlyByteBuf, (Recipe)rec);
            friendlyByteBuf.writeInt(damageLightRecipe.damageItem ? 1 : 0);
        }
    }
}

