/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class OilCanRecipe
extends ShapelessRecipe {
    final int fuelAmount;

    public OilCanRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> recipeItems, int fuelAmount) {
        super(id, group, CraftingBookCategory.EQUIPMENT, result, recipeItems);
        this.fuelAmount = fuelAmount;
    }

    public boolean m_5818_(CraftingContainer grid, Level world) {
        StackedContents recipeMatcher = new StackedContents();
        Item fuelItem = null;
        int i = 0;
        for (int j = 0; j < grid.m_6643_(); ++j) {
            ItemStack itemStack = grid.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41720_() instanceof OilCanItem) {
                recipeMatcher.m_36468_(itemStack, 1);
                ++i;
                continue;
            }
            if (fuelItem == null) {
                recipeMatcher.m_36468_(itemStack, 1);
                ++i;
                fuelItem = itemStack.m_41720_();
                continue;
            }
            if (fuelItem == itemStack.m_41720_()) continue;
            recipeMatcher.m_36468_(itemStack, 1);
            ++i;
        }
        boolean match = recipeMatcher.m_36475_((Recipe)this, null);
        return i == this.m_7527_().size() && match;
    }

    public ItemStack m_5874_(CraftingContainer grid, RegistryAccess registryAccess) {
        int startFuel = 0;
        int addFuel = 0;
        ItemStack resultStack = ItemStack.f_41583_;
        for (int i = 0; i < grid.m_6643_(); ++i) {
            ItemStack itemstack = grid.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof OilCanItem) {
                OilCanItem can = (OilCanItem)itemstack.m_41720_();
                startFuel = OilCanItem.getFuel(itemstack);
                resultStack = itemstack;
                continue;
            }
            addFuel = (int)((double)addFuel + (double)this.fuelAmount * (Double)Config.oilRecipeMultiplier.get());
        }
        if (resultStack.m_41720_() instanceof OilCanItem) {
            return OilCanItem.setFuel(resultStack.m_41777_(), startFuel + addFuel);
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<OilCanRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("hardcore_torches", "oil_can");

        public OilCanRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(resourceLocation, json);
            int fuel = json.get("fuel").getAsInt();
            return new OilCanRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(null), (NonNullList<Ingredient>)recipe.m_7527_(), fuel);
        }

        public OilCanRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_8005_(resourceLocation, friendlyByteBuf);
            int fuelValue = friendlyByteBuf.m_130242_();
            return new OilCanRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(null), (NonNullList<Ingredient>)recipe.m_7527_(), fuelValue);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, OilCanRecipe oilCanRecipe) {
            ShapelessRecipe rec = new ShapelessRecipe(oilCanRecipe.m_6423_(), oilCanRecipe.m_6076_(), CraftingBookCategory.EQUIPMENT, oilCanRecipe.m_8043_(null), oilCanRecipe.m_7527_());
            ShapelessRecipe.Serializer.f_44077_.m_6178_(friendlyByteBuf, (Recipe)rec);
            friendlyByteBuf.m_130130_(oilCanRecipe.fuelAmount);
        }
    }
}

