/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.util;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SoulAttunement {
    public static InteractionResult soulAttune(Level world, BlockPos pos, IFuelBlockEntity fuelBlockEntity, IFuelBlock fuelBlock, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ExperienceBottleItem) {
            if (!world.f_46443_) {
                int oldFuel = fuelBlockEntity.getFuel();
                if (fuelBlockEntity.canAddFuel()) {
                    if (oldFuel + (Integer)Config.defLanternFuelItem.get() < fuelBlock.getMaxFuel()) {
                        world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    stack.m_41769_(-1);
                    fuelBlockEntity.setFuel((int)((double)oldFuel + (double)((Integer)Config.bottleExpAmount.get()).intValue() * (Double)Config.soulExpRatio.get()));
                    SoulAttunement.displaySpirit(player, fuelBlockEntity.getFuel());
                }
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(MainMod.SOUL_ITEMS)) {
            if (!world.f_46443_) {
                int xp = SoulAttunement.getTotalXP(player);
                int maxIncrement = Math.min(xp, (Integer)Config.expIncrement.get());
                int emptySpace = Math.max(0, fuelBlockEntity.getMaxFuel() - fuelBlockEntity.getFuel());
                int addAmount = Math.min(emptySpace, (int)((double)maxIncrement * (Double)Config.soulExpRatio.get()));
                int takeAmount = (int)Math.max(0.0, Math.ceil((double)addAmount / (Double)Config.soulExpRatio.get()));
                if (xp > 0) {
                    if (addAmount > 0 && fuelBlockEntity.canAddFuel()) {
                        fuelBlockEntity.setFuel(fuelBlockEntity.getFuel() + addAmount);
                        player.m_6756_(-takeAmount);
                        world.m_5594_(null, pos, SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        SoulAttunement.displaySpirit(player, fuelBlockEntity.getFuel());
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"You don't have enough XP!"), true);
                }
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static void displaySpirit(Player player, int amount) {
        player.m_5661_((Component)Component.m_237113_((String)("Spirit: " + amount)), true);
    }

    private static int getTotalXP(Player player) {
        int level = player.f_36078_;
        int levelTotal = 0;
        if (level >= 1 && level <= 16) {
            levelTotal = (int)(Math.pow(level, 2.0) + (double)(6 * level));
        } else if (level >= 17 && level <= 31) {
            levelTotal = (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        } else if (level >= 32) {
            levelTotal = (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return levelTotal + player.f_36079_;
    }
}

