/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches;

import com.github.wolfiewaffle.hardcore_torches.compat.amendments.AmendmentsCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.FarmersCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.config.ConfigRecipeCondition;
import com.github.wolfiewaffle.hardcore_torches.event.PlayerEventHandler;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.init.BlockInit;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.loot.FatModifier;
import com.github.wolfiewaffle.hardcore_torches.loot.ReplaceTorchModifier;
import com.github.wolfiewaffle.hardcore_torches.loot.SetFuelLootFunction;
import com.github.wolfiewaffle.hardcore_torches.loot.TorchLootFunction;
import com.github.wolfiewaffle.hardcore_torches.recipe.DamageLightRecipe;
import com.github.wolfiewaffle.hardcore_torches.recipe.OilCanRecipe;
import com.github.wolfiewaffle.hardcore_torches.recipe.TorchRecipe;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.world.ReplaceAllBiomeModifier;
import com.github.wolfiewaffle.hardcore_torches.world.ReplaceAllFeature;
import com.google.common.base.Supplier;
import com.mojang.serialization.Codec;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="hardcore_torches")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="hardcore_torches")
public class MainMod {
    public static final String MOD_ID = "hardcore_torches";
    public static TorchGroup basicTorches = new TorchGroup("basic", true);
    public static TorchGroup soulTorches = new TorchGroup("soul", false);
    public static LanternGroup basicLanterns = new LanternGroup("basic");
    public static LanternGroup soulLanterns = new LanternGroup("soul");
    public static final TagKey<Item> MC_ANIMAL_FAT = ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:animal_fat"));
    public static final TagKey<Item> ALL_TORCH_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:torches"));
    public static final TagKey<Item> ACTIVE_TORCHES = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:active_torches"));
    public static final TagKey<Item> INACTIVE_TORCHES = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:inactive_torches"));
    public static final TagKey<Block> FREE_TORCH_LIGHT_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:free_torch_light_blocks"));
    public static final TagKey<Item> FREE_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:free_torch_light_items"));
    public static final TagKey<Item> DAMAGE_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:damage_torch_light_items"));
    public static final TagKey<Item> CONSUME_TORCH_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:consume_torch_light_items"));
    public static final TagKey<Item> FREE_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:free_torch_extinguish_items"));
    public static final TagKey<Item> DAMAGE_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:damage_torch_extinguish_items"));
    public static final TagKey<Item> CONSUME_TORCH_EXTINGUISH_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:consume_torch_extinguish_items"));
    public static final TagKey<Item> FREE_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:free_torch_smother_items"));
    public static final TagKey<Item> DAMAGE_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:damage_torch_smother_items"));
    public static final TagKey<Item> CONSUME_TORCH_SMOTHER_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:consume_torch_smother_items"));
    public static final TagKey<Item> FREE_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:free_lantern_light_items"));
    public static final TagKey<Item> DAMAGE_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:damage_lantern_light_items"));
    public static final TagKey<Item> CONSUME_LANTERN_LIGHT_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:consume_lantern_light_items"));
    public static final TagKey<Item> SOUL_ITEMS = ItemTags.create((ResourceLocation)new ResourceLocation("hardcore_torches:soul_attunement_items"));
    public static final LootItemFunctionType HARDCORE_TORCH_LOOT_FUNCTION = new LootItemFunctionType((Serializer)new TorchLootFunction.Serializer());
    public static final LootItemFunctionType SET_FUEL_LOOT_FUNCTION = new LootItemFunctionType((Serializer)new SetFuelLootFunction.Serializer());
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"hardcore_torches");
    public static final RegistryObject<RecipeType<OilCanRecipe>> OIL_CAN_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("oil_can", () -> new RecipeType<OilCanRecipe>(){});
    public static final RegistryObject<RecipeType<DamageLightRecipe>> DAMAGE_LIGHT_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("damage_light", () -> new RecipeType<DamageLightRecipe>(){});
    public static final RegistryObject<RecipeType<TorchRecipe>> TORCH_RECIPE = RECIPE_TYPE_DEFERRED_REGISTER.register("torch", () -> new RecipeType<TorchRecipe>(){});
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256764_, (String)"hardcore_torches");
    private static final RegistryObject<OilCanRecipe.Serializer> OIL_CAN_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("oil_can", OilCanRecipe.Serializer::new);
    private static final RegistryObject<DamageLightRecipe.Serializer> DAMAGE_LIGHT_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("damage_light", DamageLightRecipe.Serializer::new);
    private static final RegistryObject<TorchRecipe.Serializer> TORCH_RECIPE_SERIALIZER = RECIPE_SERIALIZER_DEFERRED_REGISTER.register("torch", TorchRecipe.Serializer::new);
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MOD_CODEC_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"hardcore_torches");
    public static final RegistryObject<Codec<FatModifier>> FAT_MOD_CODEC = LOOT_MOD_CODEC_REGISTER.register("fat_modifier", () -> FatModifier.codec);
    public static final RegistryObject<Codec<ReplaceTorchModifier>> REPLACE_TORCH_MOD_CODEC = LOOT_MOD_CODEC_REGISTER.register("replace_torches_in_containers", () -> ReplaceTorchModifier.codec);
    private static final DeferredRegister<LootItemFunctionType> LOOT_FUNC_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"hardcore_torches");
    public static final RegistryObject<LootItemFunctionType> TORCH_LOOT_FUNCTION_TYPE = LOOT_FUNC_REGISTER.register("torch", () -> HARDCORE_TORCH_LOOT_FUNCTION);
    public static final RegistryObject<LootItemFunctionType> SET_FUEL_FUNCTION_TYPE = LOOT_FUNC_REGISTER.register("set_damage", () -> SET_FUEL_LOOT_FUNCTION);
    private static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"hardcore_torches");
    private static final RegistryObject<ReplaceAllFeature> REPLACE_ALL_FEATURE = FEATURE_REGISTER.register("replace_all", () -> new ReplaceAllFeature(NoneFeatureConfiguration.f_67815_.stable()));
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"hardcore_torches");
    public static final RegistryObject<Codec<? extends BiomeModifier>> REPLACE_ALL_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("replace_all_modifier", () -> ReplaceAllBiomeModifier.CODEC);

    public MainMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        Config.init();
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        if (ModList.get().isLoaded("amendments")) {
            AmendmentsCommonCompat.loadCompat();
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.loadCompat();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        LOOT_MOD_CODEC_REGISTER.register(modEventBus);
        LOOT_FUNC_REGISTER.register(modEventBus);
        RECIPE_TYPE_DEFERRED_REGISTER.register(modEventBus);
        RECIPE_SERIALIZER_DEFERRED_REGISTER.register(modEventBus);
        FEATURE_REGISTER.register(modEventBus);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> this.afterCommonSetup());
        basicTorches.add((Block)BlockInit.LIT_TORCH.get());
        basicTorches.add((Block)BlockInit.LIT_WALL_TORCH.get());
        basicTorches.add((Block)BlockInit.UNLIT_TORCH.get());
        basicTorches.add((Block)BlockInit.UNLIT_WALL_TORCH.get());
        basicTorches.add((Block)BlockInit.SMOLDERING_TORCH.get());
        basicTorches.add((Block)BlockInit.SMOLDERING_WALL_TORCH.get());
        basicTorches.add((Block)BlockInit.BURNT_TORCH.get());
        basicTorches.add((Block)BlockInit.BURNT_WALL_TORCH.get());
        basicLanterns.add((Block)BlockInit.LIT_LANTERN.get());
        basicLanterns.add((Block)BlockInit.UNLIT_LANTERN.get());
        soulLanterns.add((Block)BlockInit.LIT_SOUL_LANTERN.get());
        soulLanterns.add((Block)BlockInit.UNLIT_SOUL_LANTERN.get());
        soulTorches.add((Block)BlockInit.LIT_SOUL_TORCH.get());
        soulTorches.add((Block)BlockInit.LIT_WALL_SOUL_TORCH.get());
        soulTorches.add((Block)BlockInit.UNLIT_SOUL_TORCH.get());
        soulTorches.add((Block)BlockInit.UNLIT_WALL_SOUL_TORCH.get());
        if (ModList.get().isLoaded("amendments")) {
            AmendmentsCommonCompat.loadData();
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.loadData();
        }
    }

    private void afterCommonSetup() {
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Boolean)Config.craftHardcoreCampfire.get()), new ResourceLocation(MOD_ID, "config_hardcore_campfire")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Boolean)Config.craftUnlit.get()), new ResourceLocation(MOD_ID, "config_craft_unlit")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Boolean)Config.craftLight.get()), new ResourceLocation(MOD_ID, "config_craft_light")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Integer)Config.oilRecipeType.get() == 0 || (Integer)Config.oilRecipeType.get() == 2), new ResourceLocation(MOD_ID, "config_can_fat")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Integer)Config.oilRecipeType.get() == 1 || (Integer)Config.oilRecipeType.get() == 2), new ResourceLocation(MOD_ID, "config_can_coal")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Boolean)Config.lanternsUseFuel.get()), new ResourceLocation(MOD_ID, "lanterns_use_fuel")));
        CraftingHelper.register((IConditionSerializer)new ConfigRecipeCondition.Serializer((Supplier<Boolean>)((Supplier)() -> (Boolean)Config.craftHardcoreStove.get()), new ResourceLocation(MOD_ID, "craft_hardcore_stove")));
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ItemInit.OIL_CAN);
            event.m_246342_(OilCanItem.setFuel(new ItemStack((ItemLike)ItemInit.OIL_CAN.get()), (Integer)Config.maxCanFuel.get()));
            event.accept(ItemInit.FIRE_STARTER);
            event.accept(ItemInit.ANIMAL_FAT);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(ItemInit.LIT_TORCH);
            event.accept(ItemInit.UNLIT_TORCH);
            event.accept(ItemInit.SMOLDERING_TORCH);
            event.accept(ItemInit.BURNT_TORCH);
            event.accept(ItemInit.LIT_SOUL_TORCH);
            event.accept(ItemInit.UNLIT_SOUL_TORCH);
            event.accept(ItemInit.LIT_LANTERN);
            event.accept(ItemInit.UNLIT_LANTERN);
            event.accept(ItemInit.LIT_SOUL_LANTERN);
            event.accept(ItemInit.UNLIT_SOUL_LANTERN);
            event.accept(ItemInit.UNLIT_CAMPFIRE);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersCommonCompat.creativeTab(event);
        }
    }
}

