/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.LanternBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import com.github.wolfiewaffle.hardcore_torches.item.LanternItem;
import com.github.wolfiewaffle.hardcore_torches.util.LanternGroup;
import com.github.wolfiewaffle.hardcore_torches.util.LanternTools;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLanternBlock
extends BaseEntityBlock
implements EntityBlock,
IFuelBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int LANTERN_LIGHT_LEVEL = 15;
    public boolean isLit;
    public LanternGroup group;
    public IntSupplier maxFuel;

    protected AbstractLanternBlock(BlockBehaviour.Properties prop, boolean isLit, IntSupplier maxFuel) {
        super(prop);
        this.isLit = isLit;
        this.maxFuel = maxFuel;
    }

    @Override
    public boolean isSoulVariant() {
        return this.group == MainMod.soulLanterns;
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    @Override
    public boolean canLight(Level world, BlockPos pos) {
        return (((LanternBlockEntity)world.m_7702_(pos)).getFuel() > 0 || (Boolean)Config.relightLanterns.get() != false) && !this.isLit;
    }

    @Override
    public void extinguish(Level world, BlockPos pos, BlockState state, boolean playSound) {
        if (!world.f_46443_) {
            if (playSound) {
                world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123755_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            TorchTools.displayParticle(ParticleTypes.f_123762_, state, world, pos);
            this.setState(world, pos, false);
        }
    }

    @Override
    public InteractionResult attemptLight(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, InteractionHand hand) {
        return LanternTools.basicAttemptLight(world, pos, player, stack, hand);
    }

    @Override
    public void light(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            BlockEntity blockEntity;
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setState(world, pos, true);
            if (((Boolean)Config.relightLanterns.get()).booleanValue() && world.m_7702_(pos) != null && (blockEntity = world.m_7702_(pos)) instanceof IFuelBlockEntity) {
                IFuelBlockEntity fuel = (IFuelBlockEntity)blockEntity;
                fuel.setFuel((Integer)Config.defaultLanternFuel.get());
            }
        }
    }

    public void setState(Level world, BlockPos pos, boolean lit) {
        BlockState oldState = world.m_8055_(pos);
        BlockState newState = this.group.getLanternBlock(lit).m_49966_();
        newState = (BlockState)((BlockState)newState.m_61124_((Property)HANGING, (Comparable)((Boolean)oldState.m_61143_((Property)HANGING)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)oldState.m_61143_((Property)WATERLOGGED)));
        int newFuel = 0;
        if (world.m_7702_(pos) != null) {
            newFuel = ((FuelBlockEntity)world.m_7702_(pos)).getFuel();
        }
        world.m_46597_(pos, newState);
        if (world.m_7702_(pos) != null) {
            ((FuelBlockEntity)world.m_7702_(pos)).setFuel(newFuel);
        }
    }

    @Override
    public ItemStack getStack(Level world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)world.m_8055_(pos).m_60734_().m_5456_());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null && blockEntity instanceof FuelBlockEntity) {
            int remainingFuel = ((FuelBlockEntity)blockEntity).getFuel();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("Fuel", remainingFuel);
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return LanternTools.interactLantern(state, world, pos, player, hand);
    }

    @Override
    public boolean isLit() {
        return this.isLit;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        BlockEntity be = world.m_7702_(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.m_41720_() instanceof LanternItem) {
            int fuel = LanternItem.getFuel(itemStack);
            ((FuelBlockEntity)be).setFuel(fuel);
        }
    }

    public boolean isLightItem(ItemStack stack) {
        if (stack.m_204117_(MainMod.FREE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.m_204117_(MainMod.DAMAGE_LANTERN_LIGHT_ITEMS)) {
            return true;
        }
        return stack.m_204117_(MainMod.CONSUME_LANTERN_LIGHT_ITEMS);
    }

    @Override
    public void outOfFuel(Level world, BlockPos pos, BlockState state) {
        ((AbstractLanternBlock)world.m_8055_(pos).m_60734_()).extinguish(world, pos, state, true);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Blocks.f_50681_.m_5940_(state, getter, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = Blocks.f_50681_.m_5573_(context);
        BlockState newState = null;
        if (state != null) {
            newState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)((Boolean)state.m_61143_((Property)HANGING)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
        }
        return newState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{HANGING, WATERLOGGED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type == BlockEntityInit.LANTERN_BLOCK_ENTITY.get() ? (level, pos, blockState, be) -> ((LanternBlockEntity)be).tick() : super.m_142354_(world, state, type);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        LanternBlockEntity be = new LanternBlockEntity(pos, state);
        be.setFuel((Integer)Config.startingLanternFuel.get());
        return be;
    }

    public boolean m_7898_(BlockState p_153479_, LevelReader p_153480_, BlockPos p_153481_) {
        return Blocks.f_50681_.m_7898_(p_153479_, p_153480_, p_153481_);
    }

    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        return Blocks.f_50681_.m_7417_(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    public FluidState m_5888_(BlockState p_153492_) {
        return Blocks.f_50681_.m_5888_(p_153492_);
    }

    public boolean m_7357_(BlockState p_153469_, BlockGetter p_153470_, BlockPos p_153471_, PathComputationType p_153472_) {
        return Blocks.f_50681_.m_7357_(p_153469_, p_153470_, p_153471_, p_153472_);
    }
}

