/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FuelBlockEntity
extends BlockEntity
implements IFuelBlockEntity {
    protected int fuel;
    protected static Random random = new Random();

    public FuelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public int getMaxFuel() {
        return 0;
    }

    @Override
    public void setFuel(int newValue) {
        this.fuel = Math.min(this.getMaxFuel(), Math.max(0, newValue));
    }

    @Override
    public boolean canAddFuel() {
        return this.getFuel() < this.getMaxFuel();
    }

    public void changeFuel(int increment) {
        Level world = this.m_58904_();
        BlockPos pos = this.m_58899_();
        this.fuel += increment;
        if (this.fuel <= 0) {
            this.fuel = 0;
            if (world.m_8055_(pos).m_60734_() instanceof IFuelBlock) {
                IFuelBlock block = (IFuelBlock)world.m_8055_(pos).m_60734_();
                block.outOfFuel(world, pos, world.m_8055_(pos));
            }
        } else if (this.fuel > this.getMaxFuel()) {
            this.setFuel(this.getMaxFuel());
        }
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt != null) {
            super.m_142466_(nbt);
            this.fuel = nbt.m_128451_("Fuel");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Fuel", this.fuel);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }
}

