/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.block.HardcoreCampfire;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.BlockEntityInit;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class HardcoreCampfireBlockEntity
extends CampfireBlockEntity {
    protected int fuel = 0;

    public HardcoreCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        CampfireBlockEntity.m_155318_((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    public static void cookTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        if (entity.fuel <= 0) {
            Block block = state.m_60734_();
            if (block instanceof HardcoreCampfire) {
                HardcoreCampfire campfire = (HardcoreCampfire)block;
                campfire.outOfFuel(world, pos, state);
            }
        } else {
            --entity.fuel;
        }
        HardcoreCampfireBlockEntity.takeFuelItems(world, pos, entity);
        CampfireBlockEntity.m_155306_((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    public static void cooldownTick(Level world, BlockPos pos, BlockState state, HardcoreCampfireBlockEntity entity) {
        HardcoreCampfireBlockEntity.takeFuelItems(world, pos, entity);
        CampfireBlockEntity.m_155313_((Level)world, (BlockPos)pos, (BlockState)state, (CampfireBlockEntity)entity);
    }

    private static void takeFuelItems(Level world, BlockPos pos, HardcoreCampfireBlockEntity entity) {
        for (ItemEntity itementity : HardcoreCampfireBlockEntity.getItemsAtAndAbove(world, pos)) {
            FuelResult result;
            int burnTime = ForgeHooks.getBurnTime((ItemStack)itementity.m_32055_(), (RecipeType)RecipeType.f_44108_);
            if (burnTime <= 0 || (result = entity.setFuel((int)((double)entity.getFuel() + (double)burnTime * (Double)Config.campfireFuelFactor.get()))) == FuelResult.FULL) continue;
            itementity.m_6074_();
            world.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (result != FuelResult.SOME_WASTE || !HardcoreCampfireBlockEntity.isLit(world, pos)) continue;
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.5f);
        }
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)BlockEntityInit.CAMPFIRE_BLOCK_ENTITY.get();
    }

    public int getFuel() {
        return this.fuel;
    }

    public static boolean isLit(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_61138_((Property)CampfireBlock.f_51227_)) {
            return (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_);
        }
        return false;
    }

    public FuelResult setFuel(int newValue) {
        if (this.fuel >= (Integer)Config.campfireMaxFuel.get()) {
            return FuelResult.FULL;
        }
        this.fuel = newValue;
        if (this.fuel > (Integer)Config.campfireMaxFuel.get()) {
            this.fuel = (Integer)Config.campfireMaxFuel.get();
            return FuelResult.SOME_WASTE;
        }
        return FuelResult.HAD_SPACE;
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level world, BlockPos pos) {
        VoxelShape INSIDE = Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        VoxelShape ABOVE = Block.m_49796_((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
        VoxelShape BOTH = Shapes.m_83110_((VoxelShape)INSIDE, (VoxelShape)ABOVE);
        return BOTH.m_83299_().stream().flatMap(aabb -> world.m_6443_(ItemEntity.class, aabb.m_82386_((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public void m_142466_(CompoundTag nbt) {
        if (nbt != null) {
            super.m_142466_(nbt);
            this.fuel = nbt.m_128451_("Fuel");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    private static enum FuelResult {
        HAD_SPACE,
        SOME_WASTE,
        FULL;

    }
}

