/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.blockentity;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IFuelBlock {
    public int getMaxFuel();

    public ItemStack getStack(Level var1, BlockPos var2);

    public void outOfFuel(Level var1, BlockPos var2, BlockState var3);

    public void extinguish(Level var1, BlockPos var2, BlockState var3, boolean var4);

    public void light(Level var1, BlockPos var2);

    public InteractionResult attemptLight(Level var1, BlockPos var2, BlockState var3, Player var4, ItemStack var5, InteractionHand var6);

    default public boolean itemValid(ItemStack stack, ETorchState attemptedState) {
        switch (attemptedState) {
            case LIT: {
                return this.isValidStack(stack, this.getFreeLightItems(), this.getDamageLightItems(), this.getConsumeLightItems());
            }
            case SMOLDERING: {
                return this.isValidStack(stack, this.getFreeSmotherItems(), this.getDamageSmotherItems(), this.getConsumeSmotherItems());
            }
            case UNLIT: {
                return this.isValidStack(stack, this.getFreeExtinguishItems(), this.getDamageExtinguishItems(), this.getConsumeExtinguishItems());
            }
        }
        return false;
    }

    default public boolean attemptUseItem(ItemStack stack, Player player, InteractionHand hand, ETorchState attemptedState) {
        switch (attemptedState) {
            case LIT: {
                return this.privateAttemptUse(stack, player, hand, this.getFreeLightItems(), this.getDamageLightItems(), this.getConsumeLightItems());
            }
            case SMOLDERING: {
                return this.privateAttemptUse(stack, player, hand, this.getFreeSmotherItems(), this.getDamageSmotherItems(), this.getConsumeSmotherItems());
            }
            case UNLIT: {
                return this.privateAttemptUse(stack, player, hand, this.getFreeExtinguishItems(), this.getDamageExtinguishItems(), this.getConsumeExtinguishItems());
            }
        }
        return false;
    }

    default public boolean isValidStack(ItemStack stack, TagKey free, TagKey damage, TagKey consume) {
        if (stack.m_204117_(free)) {
            return true;
        }
        if (stack.m_204117_(damage)) {
            return true;
        }
        return stack.m_204117_(consume);
    }

    private boolean privateAttemptUse(ItemStack stack, Player player, InteractionHand hand, TagKey free, TagKey damage, TagKey consume) {
        if (free != null && stack.m_204117_(free)) {
            return true;
        }
        if (damage != null && stack.m_204117_(damage)) {
            if (stack.m_41763_() && player instanceof ServerPlayer) {
                stack.m_220157_(1, RandomSource.m_216327_(), (ServerPlayer)player);
            }
            return true;
        }
        if (consume != null && stack.m_204117_(consume)) {
            if (!player.m_7500_()) {
                stack.m_41769_(-1);
            }
            return true;
        }
        return false;
    }

    public boolean isLit();

    public boolean canLight(Level var1, BlockPos var2);

    default public TagKey getFreeLightItems() {
        return MainMod.FREE_TORCH_LIGHT_ITEMS;
    }

    default public TagKey getDamageLightItems() {
        return MainMod.DAMAGE_TORCH_LIGHT_ITEMS;
    }

    default public TagKey getConsumeLightItems() {
        return MainMod.CONSUME_TORCH_LIGHT_ITEMS;
    }

    default public TagKey getFreeExtinguishItems() {
        return MainMod.FREE_TORCH_EXTINGUISH_ITEMS;
    }

    default public TagKey getDamageExtinguishItems() {
        return MainMod.DAMAGE_TORCH_EXTINGUISH_ITEMS;
    }

    default public TagKey getConsumeExtinguishItems() {
        return MainMod.CONSUME_TORCH_EXTINGUISH_ITEMS;
    }

    default public TagKey getFreeSmotherItems() {
        return MainMod.FREE_TORCH_SMOTHER_ITEMS;
    }

    default public TagKey getDamageSmotherItems() {
        return MainMod.DAMAGE_TORCH_SMOTHER_ITEMS;
    }

    default public TagKey getConsumeSmotherItems() {
        return MainMod.CONSUME_TORCH_SMOTHER_ITEMS;
    }

    public boolean isSoulVariant();
}

