/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight;

import com.github.wolfiewaffle.hardcore_torches.compat.farmersdelight.FarmersCommonCompat;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.StoveBlockEntity;

public class HardcoreStoveBlockEntity
extends StoveBlockEntity {
    int fuel = 0;

    public HardcoreStoveBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public void addFuel(int additional) {
        this.fuel += additional;
        if (this.fuel > (Integer)Config.campfireMaxFuel.get()) {
            this.fuel = (Integer)Config.campfireMaxFuel.get();
        }
    }

    public boolean canAcceptFuel(int additional) {
        return this.fuel + additional <= (Integer)Config.campfireMaxFuel.get();
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)FarmersCommonCompat.STOVE_BLOCK_ENTITY.get();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HardcoreStoveBlockEntity stove) {
        Block block;
        StoveBlockEntity.cookingTick((Level)level, (BlockPos)pos, (BlockState)state, (StoveBlockEntity)stove);
        --stove.fuel;
        if (stove.fuel <= 0 && (block = state.m_60734_()) instanceof StoveBlock) {
            StoveBlock stoveBlock = (StoveBlock)block;
            stoveBlock.extinguish(state, level, pos);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, HardcoreStoveBlockEntity stove) {
        StoveBlockEntity.animationTick((Level)level, (BlockPos)pos, (BlockState)state, (StoveBlockEntity)stove);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.fuel = compound.m_128441_("Fuel") ? compound.m_128451_("Fuel") : 0;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Fuel", this.fuel);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }
}

