/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.util;

import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.init.ItemInit;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.SoulAttunement;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LanternTools {
    public static InteractionResult basicAttemptLight(Level world, BlockPos pos, Player player, ItemStack stack, InteractionHand hand) {
        boolean isSoul = false;
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof IFuelBlock) {
            IFuelBlock lantern = (IFuelBlock)block;
            isSoul = lantern.isSoulVariant();
        }
        if ((block = world.m_8055_(pos).m_60734_()) instanceof IFuelBlock) {
            IFuelBlock block2 = (IFuelBlock)block;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof IFuelBlockEntity) {
                IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)blockEntity;
                if (!world.f_46443_) {
                    if (fuelBlockEntity.getFuel() < (Integer)Config.minLanternIgnitionFuel.get() && !((Boolean)Config.relightLanterns.get()).booleanValue()) {
                        world.m_5594_(null, pos, SoundEvents.f_12027_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!isSoul) {
                            player.m_5661_((Component)Component.m_237113_((String)"Needs fuel from an Oil Can"), true);
                        } else {
                            player.m_5661_((Component)Component.m_237113_((String)"Needs XP from an Amethyst Shard"), true);
                        }
                    } else if (block2.attemptUseItem(stack, player, hand, ETorchState.LIT)) {
                        block2.light(world, pos);
                    }
                }
            }
        }
        player.m_6674_(hand);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult interactLantern(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        boolean showFuel;
        ItemStack stack = player.m_21120_(hand);
        if (!(world.m_7702_(pos) instanceof IFuelBlockEntity)) {
            return InteractionResult.FAIL;
        }
        IFuelBlockEntity fuelBlockEntity = (IFuelBlockEntity)world.m_7702_(pos);
        if (!(state.m_60734_() instanceof IFuelBlock)) {
            return InteractionResult.FAIL;
        }
        IFuelBlock block = (IFuelBlock)state.m_60734_();
        boolean isSoul = false;
        Block block2 = state.m_60734_();
        if (block2 instanceof IFuelBlock) {
            IFuelBlock lantern = (IFuelBlock)block2;
            isSoul = lantern.isSoulVariant();
        }
        if (player.m_6047_() && ((Boolean)Config.pickUpLanterns.get()).booleanValue()) {
            if (!world.f_46443_) {
                player.m_36356_(block.getStack(world, pos));
                world.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (!block.isLit() && block.itemValid(stack, ETorchState.LIT)) {
            return block.attemptLight(world, pos, state, player, stack, hand);
        }
        if (((Boolean)Config.relightLanterns.get()).booleanValue() && block.isLit()) {
            return block.attemptLight(world, pos, state, player, stack, hand);
        }
        if (((Boolean)Config.handUnlightLantern.get()).booleanValue() && block.isLit() && !TorchTools.canLight(stack.m_41720_(), state.m_60734_().m_49966_())) {
            block.extinguish(world, pos, state, true);
            return InteractionResult.SUCCESS;
        }
        boolean bl = showFuel = (stack.m_41619_() || stack.m_41720_() == ItemInit.OIL_CAN.get()) && (Boolean)Config.fuelMessage.get() != false;
        if (hand == InteractionHand.MAIN_HAND && !world.f_46443_ && showFuel) {
            player.m_5661_((Component)Component.m_237113_((String)("Fuel: " + fuelBlockEntity.getFuel())), true);
        }
        if (isSoul) {
            return SoulAttunement.soulAttune(world, pos, fuelBlockEntity, block, player, hand);
        }
        if (stack.m_204117_(ItemTags.f_13160_) && !((Boolean)Config.lanternsNeedCan.get()).booleanValue()) {
            if (!world.f_46443_) {
                int oldFuel = fuelBlockEntity.getFuel();
                if (fuelBlockEntity.canAddFuel()) {
                    if (oldFuel + (Integer)Config.defLanternFuelItem.get() < block.getMaxFuel()) {
                        world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    stack.m_41769_(-1);
                    fuelBlockEntity.setFuel(Math.min(oldFuel + (Integer)Config.defLanternFuelItem.get(), block.getMaxFuel()));
                }
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof OilCanItem && ((Boolean)Config.lanternsNeedCan.get()).booleanValue()) {
            if (!world.f_46443_ && OilCanItem.fuelBlock(fuelBlockEntity, world, stack)) {
                world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

