/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.util;

import com.github.wolfiewaffle.hardcore_torches.block.HardcoreFloorTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreWallTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import java.util.HashMap;
import net.minecraft.world.level.block.Block;

public class TorchGroup {
    private HashMap<ETorchState, HardcoreFloorTorchBlock> standingTorches = new HashMap();
    private HashMap<ETorchState, HardcoreWallTorchBlock> wallTorches = new HashMap();
    public final String name;
    private boolean canSmolder;

    public TorchGroup(String name, boolean canSmolder) {
        this.name = name;
        this.canSmolder = canSmolder;
    }

    public void add(Block block) {
        if (block instanceof HardcoreFloorTorchBlock) {
            this.add((HardcoreFloorTorchBlock)block);
        } else if (block instanceof HardcoreWallTorchBlock) {
            this.add((HardcoreWallTorchBlock)block);
        }
    }

    public void add(HardcoreFloorTorchBlock block) {
        this.standingTorches.put(block.burnState, block);
        block.group = this;
    }

    public void add(HardcoreWallTorchBlock block) {
        this.wallTorches.put(block.burnState, block);
        block.group = this;
    }

    public HardcoreFloorTorchBlock getStandingTorch(ETorchState state) {
        return this.standingTorches.get((Object)state);
    }

    public HardcoreWallTorchBlock getWallTorch(ETorchState state) {
        return this.wallTorches.get((Object)state);
    }

    public boolean canSmolder() {
        return this.canSmolder;
    }
}

