/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.block;

import com.github.wolfiewaffle.hardcore_torches.Mod;
import com.github.wolfiewaffle.hardcore_torches.block.HardcoreWallTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.HardcoreCampfireBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.blockentity.TorchBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.github.wolfiewaffle.hardcore_torches.item.TorchItem;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import com.github.wolfiewaffle.hardcore_torches.util.TorchTools;
import java.util.function.IntSupplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHardcoreTorchBlock
extends class_2248
implements class_2343,
IFuelBlock {
    public class_2394 particle;
    public ETorchState burnState;
    public TorchGroup group;
    public IntSupplier maxFuel;

    public AbstractHardcoreTorchBlock(class_4970.class_2251 settings, class_2394 particle, ETorchState type, IntSupplier maxFuel) {
        super(settings);
        this.particle = particle;
        this.burnState = type;
        this.maxFuel = maxFuel;
    }

    public void smother(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.SMOLDERING);
        }
    }

    public void extinguish(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            System.out.println("EXT");
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.UNLIT);
        }
    }

    public void burnOut(class_1937 world, class_2338 pos, class_2680 state, boolean playSound) {
        if (!world.field_9236) {
            if (playSound) {
                world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            }
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.BURNT);
        }
    }

    public void light(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            world.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 0.5f, 1.2f);
            TorchTools.displayParticle((class_2394)class_2398.field_11239, state, world, pos);
            TorchTools.displayParticle((class_2394)class_2398.field_11240, state, world, pos);
            this.changeTorch(world, pos, state, ETorchState.LIT);
        }
    }

    public abstract boolean isWall();

    public ETorchState getBurnState() {
        return this.burnState;
    }

    public void changeTorch(class_1937 world, class_2338 pos, class_2680 curState, ETorchState newType) {
        class_2680 newState = this.isWall() ? (class_2680)this.group.getWallTorch(newType).method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)curState.method_11654((class_2769)HardcoreWallTorchBlock.FACING))) : this.group.getStandingTorch(newType).method_9564();
        int newFuel = 0;
        if (world.method_8321(pos) != null) {
            newFuel = ((FuelBlockEntity)world.method_8321(pos)).getFuel();
        }
        world.method_8501(pos, newState);
        if (world.method_8321(pos) != null) {
            ((FuelBlockEntity)world.method_8321(pos)).setFuel(newFuel);
        }
    }

    public static boolean isLightItem(class_1799 stack) {
        if (stack.method_31573(Mod.FREE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        if (stack.method_31573(Mod.DAMAGE_TORCH_LIGHT_ITEMS)) {
            return true;
        }
        return stack.method_31573(Mod.CONSUME_TORCH_LIGHT_ITEMS);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TorchBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return type == Mod.TORCH_BLOCK_ENTITY ? (world1, pos, state1, be) -> TorchBlockEntity.tick(world1, pos, state1, (TorchBlockEntity)be) : null;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) {
            TorchTools.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
        }
        if (this.burnState == ETorchState.LIT) {
            TorchTools.displayParticle(this.particle, state, world, pos);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        boolean success = false;
        if (this.burnState == ETorchState.LIT) {
            if (this.attemptUse(stack, player, hand, Mod.FREE_TORCH_EXTINGUISH_ITEMS, Mod.DAMAGE_TORCH_EXTINGUISH_ITEMS, Mod.CONSUME_TORCH_EXTINGUISH_ITEMS)) {
                this.extinguish(world, pos, state);
                player.method_6104(hand);
                return class_1269.field_5812;
            }
            if (this.attemptUse(stack, player, hand, Mod.FREE_TORCH_SMOTHER_ITEMS, Mod.DAMAGE_TORCH_SMOTHER_ITEMS, Mod.CONSUME_TORCH_SMOTHER_ITEMS)) {
                this.smother(world, pos, state);
                player.method_6104(hand);
                return class_1269.field_5812;
            }
        }
        if ((this.burnState == ETorchState.SMOLDERING || this.burnState == ETorchState.UNLIT) && this.attemptUse(stack, player, hand, Mod.FREE_TORCH_LIGHT_ITEMS, Mod.DAMAGE_TORCH_LIGHT_ITEMS, Mod.CONSUME_TORCH_LIGHT_ITEMS)) {
            this.light(world, pos, state);
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        class_2586 be = world.method_8321(pos);
        if (be.method_11017() == Mod.TORCH_BLOCK_ENTITY && !world.field_9236 && Mod.config.fuelMessage && stack.method_7960()) {
            player.method_7353(class_2561.method_30163((String)("Fuel: " + ((HardcoreCampfireBlockEntity)be).getFuel())), true);
        }
        if (Mod.config.torchesUseCan && this.burnState != ETorchState.BURNT && !world.field_9236 && OilCanItem.fuelBlock((FuelBlockEntity)be, world, stack)) {
            world.method_8396(null, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (Mod.config.handUnlightTorch && (this.burnState == ETorchState.LIT || this.burnState == ETorchState.SMOLDERING) && !TorchTools.canLight(stack.method_7909(), state)) {
            this.extinguish(world, pos, state);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 be = world.method_8321(pos);
        if (be != null && be instanceof FuelBlockEntity && itemStack.method_7909() instanceof TorchItem) {
            int fuel = TorchItem.getFuel(itemStack);
            if (fuel == 0) {
                ((FuelBlockEntity)be).setFuel(Mod.config.defaultTorchFuel);
            } else {
                ((FuelBlockEntity)be).setFuel(fuel);
            }
        }
    }

    @Override
    public void outOfFuel(class_1937 world, class_2338 pos, class_2680 state, boolean playSound) {
        this.burnOut(world, pos, state, playSound);
    }
}

