/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.Mod;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.google.gson.JsonObject;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class OilCanRecipe
extends class_1867 {
    final int fuelAmount;
    final int configType;

    public OilCanRecipe(class_2960 id, String group, class_1799 output, class_2371<class_1856> input, int fuelAmount, int configType) {
        super(id, group, class_7710.field_40250, output, input);
        this.fuelAmount = fuelAmount;
        this.configType = configType;
    }

    public class_1865<?> method_8119() {
        return Mod.OIL_RECIPE_SERIALIZER;
    }

    public boolean method_17730(class_8566 grid, class_1937 world) {
        if (this.configType == 0 && !Mod.config.enableFatOil) {
            return false;
        }
        if (this.configType == 1 && !Mod.config.enableCoalOil) {
            return false;
        }
        class_1662 recipeMatcher = new class_1662();
        class_1792 fuelItem = null;
        int i = 0;
        for (int j = 0; j < grid.method_5439(); ++j) {
            class_1799 itemStack = grid.method_5438(j);
            if (itemStack.method_7960()) continue;
            if (itemStack.method_7909() instanceof OilCanItem) {
                recipeMatcher.method_20478(itemStack, 1);
                ++i;
                continue;
            }
            if (fuelItem == null) {
                recipeMatcher.method_20478(itemStack, 1);
                ++i;
                fuelItem = itemStack.method_7909();
                continue;
            }
            if (fuelItem == itemStack.method_7909()) continue;
            recipeMatcher.method_20478(itemStack, 1);
            ++i;
        }
        boolean match = recipeMatcher.method_7402((class_1860)this, null);
        return i == this.method_8117().size() && match;
    }

    public class_1799 method_17729(class_8566 grid, class_5455 dynamicRegistryManager) {
        int startFuel = 0;
        int addFuel = 0;
        class_1799 resultStack = class_1799.field_8037;
        for (int i = 0; i < grid.method_5439(); ++i) {
            class_1799 itemstack = grid.method_5438(i);
            if (itemstack.method_7960()) continue;
            if (itemstack.method_7909() instanceof OilCanItem) {
                OilCanItem can = (OilCanItem)itemstack.method_7909();
                startFuel = OilCanItem.getFuel(itemstack);
                resultStack = itemstack;
                continue;
            }
            if (Mod.config.oilRecipeOverride > -1) {
                addFuel += Mod.config.oilRecipeOverride;
                continue;
            }
            addFuel = (int)((float)addFuel + (float)this.fuelAmount * Mod.config.oilRecipeMultiplier);
        }
        if (resultStack.method_7909() instanceof OilCanItem) {
            return OilCanItem.setFuel(resultStack.method_7972(), startFuel + addFuel);
        }
        return class_1799.field_8037;
    }

    public static class Serializer
    implements class_1865<OilCanRecipe> {
        private static final class_2960 NAME = new class_2960("hardcore_torches", "oil_can");

        public OilCanRecipe read(class_2960 resourceLocation, JsonObject json) {
            class_1867 recipe = (class_1867)class_1867.class_1868.field_9031.method_8121(resourceLocation, json);
            int fuel = json.get("fuel").getAsInt();
            int configType = json.get("config_type").getAsInt();
            return new OilCanRecipe(recipe.method_8114(), recipe.method_8112(), recipe.method_8110(null), (class_2371<class_1856>)recipe.method_8117(), fuel, configType);
        }

        public OilCanRecipe read(class_2960 resourceLocation, class_2540 friendlyByteBuf) {
            class_1867 recipe = (class_1867)class_1867.class_1868.field_9031.method_8122(resourceLocation, friendlyByteBuf);
            int fuelValue = friendlyByteBuf.method_10816();
            int configType = friendlyByteBuf.method_10816();
            return new OilCanRecipe(recipe.method_8114(), recipe.method_8112(), recipe.method_8110(null), (class_2371<class_1856>)recipe.method_8117(), fuelValue, configType);
        }

        public void write(class_2540 friendlyByteBuf, OilCanRecipe oilCanRecipe) {
            class_1867 rec = new class_1867(oilCanRecipe.method_8114(), oilCanRecipe.method_8112(), class_7710.field_40250, oilCanRecipe.method_8110(null), oilCanRecipe.method_8117());
            class_1867.class_1868.field_9031.method_8124(friendlyByteBuf, (class_1860)rec);
            friendlyByteBuf.method_10804(oilCanRecipe.fuelAmount);
            friendlyByteBuf.method_10804(oilCanRecipe.configType);
        }
    }
}

