/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranim.commands.AnimationArgumentProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.network.AnimationBinary;
import com.zigythebird.playeranimcore.network.LegacyAnimationBinary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;

public class PlayerAnimCommands {
    public static <T> void register(CommandDispatcher<T> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"testPlayerAnimation").then(Commands.argument((String)"animationID", (ArgumentType)ResourceLocationArgument.id()).suggests(new AnimationArgumentProvider()).executes(PlayerAnimCommands::execute)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"testLegacyAnimationBinary").then(Commands.argument((String)"animationID", (ArgumentType)ResourceLocationArgument.id()).suggests(new AnimationArgumentProvider()).then(Commands.argument((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)LegacyAnimationBinary.getCurrentVersion())).executes(PlayerAnimCommands::executeLegacy))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"testAnimationBinary").then(Commands.argument((String)"animationID", (ArgumentType)ResourceLocationArgument.id()).suggests(new AnimationArgumentProvider()).then(Commands.argument((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(PlayerAnimCommands::executeBinary))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"testMannequin").then(Commands.argument((String)"animationID", (ArgumentType)ResourceLocationArgument.id()).suggests(new AnimationArgumentProvider()).then(Commands.argument((String)"mannequin", (ArgumentType)UuidArgument.uuid()).executes(PlayerAnimCommands::executeMannequin))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        ResourceLocation animation = ResourceLocationArgument.getId(context, (String)"animationID");
        return PlayerAnimCommands.playAnimation(PlayerAnimResources.getAnimation(animation));
    }

    private static int executeLegacy(CommandContext<CommandSourceStack> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(ResourceLocationArgument.getId(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuf byteBuffer = Unpooled.buffer((int)LegacyAnimationBinary.calculateSize(animation, version));
        LegacyAnimationBinary.write(animation, byteBuffer, version);
        try {
            int n = PlayerAnimCommands.playAnimation(LegacyAnimationBinary.read(byteBuffer, version));
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            byteBuffer.release();
        }
    }

    private static int executeBinary(CommandContext<CommandSourceStack> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(ResourceLocationArgument.getId(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuf byteBuf = Unpooled.buffer();
        AnimationBinary.write(byteBuf, version, animation);
        return PlayerAnimCommands.playAnimation(AnimationBinary.read(byteBuf, version));
    }

    private static int playAnimation(Animation animation) {
        AnimationController controller = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((Avatar)Objects.requireNonNull(Minecraft.getInstance().player), PlayerAnimLibMod.ANIMATION_LAYER_ID);
        if (controller == null) {
            return 0;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        return 1;
    }

    private static int executeMannequin(CommandContext<CommandSourceStack> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(ResourceLocationArgument.getId(context, (String)"animationID")));
        Avatar avatar = (Avatar)Objects.requireNonNull(Minecraft.getInstance().level.getEntity(UuidArgument.getUuid(context, (String)"mannequin")));
        AnimationController controller = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer(avatar, PlayerAnimLibMod.ANIMATION_LAYER_ID);
        if (controller == null) {
            return 0;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        return 1;
    }
}

