/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.util;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.AccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ArrayAccessExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.BinaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.CallExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExecutionScopeExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.IdentifierExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StatementExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.StringExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.TernaryConditionalExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.UnaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.util.network.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ExprBytesUtils {
    private static final Map<Class<? extends Expression>, Byte> EXPR_TO_BYTE = new HashMap<Class<? extends Expression>, Byte>();
    private static final Map<Byte, Function<ByteBuf, ? extends Expression>> BYTE_TO_EXPR = new HashMap<Byte, Function<ByteBuf, ? extends Expression>>();

    public static <T extends Expression> void registerExpression(byte id, Class<T> expression, Function<ByteBuf, T> reader) {
        EXPR_TO_BYTE.put(expression, id);
        BYTE_TO_EXPR.put(id, reader);
    }

    public static void writeExpression(Expression expression, ByteBuf buf) {
        Byte id = EXPR_TO_BYTE.get(expression.getClass());
        if (id == null) {
            throw new IllegalArgumentException("Unknown expression class: " + String.valueOf(expression.getClass()));
        }
        buf.writeByte((int)id.byteValue());
        expression.write(buf);
    }

    @NotNull
    public static Expression readExpression(ByteBuf buf) {
        Function<ByteBuf, ? extends Expression> reader = BYTE_TO_EXPR.get(buf.readByte());
        if (reader == null) {
            throw new IllegalArgumentException("Unknown expression id in buffer");
        }
        return reader.apply(buf);
    }

    public static List<Expression> readExpressions(ByteBuf buf) {
        return ProtocolUtils.readList(buf, ExprBytesUtils::readExpression);
    }

    public static void writeExpressions(List<Expression> list, ByteBuf buf) {
        ProtocolUtils.writeList(buf, list, ExprBytesUtils::writeExpression);
    }

    static {
        ExprBytesUtils.registerExpression((byte)0, UnaryExpression.class, UnaryExpression::new);
        ExprBytesUtils.registerExpression((byte)1, TernaryConditionalExpression.class, TernaryConditionalExpression::new);
        ExprBytesUtils.registerExpression((byte)2, StringExpression.class, StringExpression::new);
        ExprBytesUtils.registerExpression((byte)3, StatementExpression.class, StatementExpression::new);
        ExprBytesUtils.registerExpression((byte)4, IdentifierExpression.class, IdentifierExpression::new);
        ExprBytesUtils.registerExpression((byte)5, FloatExpression.class, FloatExpression::new);
        ExprBytesUtils.registerExpression((byte)6, ExecutionScopeExpression.class, ExecutionScopeExpression::new);
        ExprBytesUtils.registerExpression((byte)7, CallExpression.class, CallExpression::new);
        ExprBytesUtils.registerExpression((byte)8, BinaryExpression.class, BinaryExpression::new);
        ExprBytesUtils.registerExpression((byte)9, ArrayAccessExpression.class, ArrayAccessExpression::new);
        ExprBytesUtils.registerExpression((byte)10, AccessExpression.class, AccessExpression::new);
    }
}

