/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;

public class TurnLeftAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        TurnLeftAnimation.handleTurningAnimation(context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.playerData().getBodyYawDelta() != 0.0f && !context.player().method_18276() && context.playerData().getBodyYawDelta() < 0.0f && !context.player().method_5765();
    }

    private static void handleTurningAnimation(AnimationContext context) {
        Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig, context.mainAnimationContainer());
        context.mainAnimationContainer().setAnimationSpeed(TurnLeftAnimation.calculateAnimationSpeed(context));
        AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.TURN_LEFT_ANIMATION);
    }

    private static float calculateAnimationSpeed(AnimationContext context) {
        float bodyYawDelta = context.playerData().getBodyYawDelta();
        float halfBodyYawDelta = 0.5f * bodyYawDelta;
        float speedMultiplier = ModTemplate.CONFIG.getMainAnimations().idleAnimations.turnAnimations.turningStandingAnimationConfig.getSpeedMultiplier();
        if (halfBodyYawDelta > 2.0f || halfBodyYawDelta < -2.0f) {
            return speedMultiplier;
        }
        return Math.abs(halfBodyYawDelta * speedMultiplier);
    }
}

