/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;

public class WalkSneakAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        WalkSneakAnimation.configureWalkSneakAnimation(context);
        AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.WALK_SNEAK_ANIMATION);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.playerData().getMovementSpeed() > 0.0 && !context.playerData().isMovingBackwards() && context.player().method_18276() && !context.player().method_5765();
    }

    private static void configureWalkSneakAnimation(AnimationContext context) {
        AnimationContainer animationContainer = context.mainAnimationContainer();
        ClientConfig.AnimationConfig config = ModTemplate.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig;
        animationContainer.setAnimationSpeed(WalkSneakAnimation.calculateAnimationSpeed(context));
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    private static float calculateAnimationSpeed(AnimationContext context) {
        return (float)(5.0 * context.playerData().getMovementSpeed() * (double)ModTemplate.CONFIG.getMainAnimations().moveAnimations.getAnimationMoveSpeedMultiplier() * (double)ModTemplate.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig.getSpeedMultiplier());
    }
}

