/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.silly_goose.entity.goose;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import net.minecraft.class_9791;
import org.jetbrains.annotations.Nullable;
import potatowolfie.silly_goose.advancement.UnfairTradeAdvancementHandler;
import potatowolfie.silly_goose.entity.SillyGooseEntities;
import potatowolfie.silly_goose.entity.goose.goals.BabyGooseFollowGoal;
import potatowolfie.silly_goose.entity.goose.goals.GooseHitAndRunGoal;
import potatowolfie.silly_goose.entity.goose.goals.GooseRevengeGoal;
import potatowolfie.silly_goose.entity.goose.goals.GooseWanderGoal;
import potatowolfie.silly_goose.entity.goose.variant.GooseVariant;
import potatowolfie.silly_goose.entity.goose.variant.GooseVariants;
import potatowolfie.silly_goose.item.SillyGooseItems;
import potatowolfie.silly_goose.registry.SillyGooseDataComponentTypes;
import potatowolfie.silly_goose.registry.SillyGooseRegistryKeys;
import potatowolfie.silly_goose.registry.SillyGooseTrackedDataHandlerRegistry;
import potatowolfie.silly_goose.sound.SillyGooseSounds;

public class GooseEntity
extends class_1429 {
    private static final class_2940<class_6880<GooseVariant>> VARIANT = class_2945.method_12791(GooseEntity.class, SillyGooseTrackedDataHandlerRegistry.GOOSE_VARIANT);
    private static final class_2940<Boolean> PREFERS_WATER = class_2945.method_12791(GooseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_PICKUP_LOOT = class_2945.method_12791(GooseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_IN_HIT_AND_RUN_MODE = class_2945.method_12791(GooseEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 idleWaterAnimationState = new class_7094();
    public final class_7094 wingsUpIdleAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 runAnimationState = new class_7094();
    public final class_7094 swimAnimationState = new class_7094();
    public final class_7094 swimFastAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private boolean isIdleAnimationRunning = false;
    private boolean isWalkingAnimationRunning = false;
    private boolean animationStartedThisTick = false;
    private int preferenceChangeTimer = 0;
    private static final int MIN_PREFERENCE_CHANGE_TIME = 4800;
    private static final int MAX_PREFERENCE_CHANGE_TIME = 7200;
    private static final float CHANCE_OF_PICK_UP_WEAPON = 1.0f;
    private int swordPickupCooldownTimer = 0;
    private int offPreferenceTimer = 0;
    private boolean isInOffPreferenceMode = false;
    private static final int MIN_OFF_PREFERENCE_TIME = 600;
    private static final int MAX_OFF_PREFERENCE_TIME = 1200;
    private int eggLayTimer = 0;
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    @Nullable
    private UUID revengeTargetUUID = null;
    private int revengeTimer = 0;
    private long revengeExpirationTime = 0L;
    private static final int MIN_REVENGE_TIMER = 1200;
    private static final int MAX_REVENGE_TIMER = 2400;
    private static final long MIN_REVENGE_DURATION_MS = 0x6DDD00L;
    private static final long MAX_REVENGE_DURATION_MS = 12000000L;
    private static final double REVENGE_NOTIFICATION_RADIUS = 64.0;
    private boolean spawnedFromEgg = false;

    public GooseEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new GooseRevengeGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GooseHitAndRunGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.1, stack -> stack.method_31573(class_3489.field_49943), false));
        this.field_6201.method_6277(5, (class_1352)new BabyGooseFollowGoal(this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new GooseWanderGoal(this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createGooseAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_51578, 1.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23728, 0.42).method_26868(class_5134.field_52450, 10.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)class_10704.method_67175((class_5455)this.method_56673(), GooseVariants.TEMPERATE));
        builder.method_56912(PREFERS_WATER, (Object)this.field_5974.method_43056());
        builder.method_56912(CAN_PICKUP_LOOT, (Object)false);
        builder.method_56912(IS_IN_HIT_AND_RUN_MODE, (Object)false);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        class_10704.method_67177((class_11372)view, this.getVariant());
        view.method_71472("PrefersWater", this.getPrefersWater());
        view.method_71472("CanPickUpLoot", this.method_5936());
        view.method_71465("PreferenceChangeTimer", this.preferenceChangeTimer);
        view.method_71465("OffPreferenceTimer", this.offPreferenceTimer);
        view.method_71472("IsInOffPreferenceMode", this.isInOffPreferenceMode);
        view.method_71465("EggLayTimer", this.eggLayTimer);
        view.method_71465("SwordPickupCooldownTimer", this.swordPickupCooldownTimer);
        if (this.revengeTargetUUID != null) {
            view.method_71468("RevengeTargetUUID", class_4844.field_40825, (Object)this.revengeTargetUUID);
        }
        view.method_71465("RevengeTimer", this.revengeTimer);
        view.method_71466("RevengeExpirationTime", this.revengeExpirationTime);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        if (!this.spawnedFromEgg) {
            class_10704.method_67178((class_11368)view, SillyGooseRegistryKeys.GOOSE_VARIANT).ifPresent(this::setVariant);
        }
        boolean savedPreference = view.method_71433("PrefersWater", this.field_5974.method_43056());
        this.setPrefersWater(savedPreference);
        boolean canPickup = view.method_71433("CanPickUpLoot", false);
        this.method_5952(canPickup);
        this.preferenceChangeTimer = view.method_71424("PreferenceChangeTimer", 0);
        this.offPreferenceTimer = view.method_71424("OffPreferenceTimer", 0);
        this.isInOffPreferenceMode = view.method_71433("IsInOffPreferenceMode", false);
        this.eggLayTimer = view.method_71424("EggLayTimer", 0);
        this.swordPickupCooldownTimer = view.method_71424("SwordPickupCooldownTimer", 0);
        view.method_71426("RevengeTargetUUID", class_4844.field_40825).ifPresent(uuid -> {
            this.revengeTargetUUID = uuid;
        });
        this.revengeTimer = view.method_71424("RevengeTimer", 0);
        this.revengeExpirationTime = view.method_71425("RevengeExpirationTime", 0L);
    }

    public void setSpawnedFromEgg(boolean spawnedFromEgg) {
        this.spawnedFromEgg = spawnedFromEgg;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608()) {
            this.setupAnimationStates();
        } else {
            this.handleWaterFloating();
            this.handlePreferenceChange();
            this.handleOffPreferenceTimer();
            this.handleEggLaying();
            this.handleRevengeTimer();
            this.handleSwordPickupCooldown();
        }
    }

    private void handleRevengeTimer() {
        double distance;
        if (this.revengeTargetUUID == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.revengeExpirationTime > 0L && currentTime >= this.revengeExpirationTime) {
            this.revengeTargetUUID = null;
            this.revengeTimer = 0;
            this.revengeExpirationTime = 0L;
            return;
        }
        class_1657 targetPlayer = this.getRevengeTargetPlayer();
        if (targetPlayer != null && (distance = this.method_5858((class_1297)targetPlayer)) <= 1024.0 && this.revengeTimer > 0) {
            --this.revengeTimer;
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1297 class_12972;
        boolean damaged = super.method_64397(world, source, amount);
        if (damaged && this.method_29504() && (class_12972 = source.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.notifyNearbyGeese(player);
        }
        return damaged;
    }

    private void notifyNearbyGeese(class_1657 killer) {
        class_238 searchBox = this.method_5829().method_1014(64.0);
        List nearbyGeese = this.method_73183().method_8390(GooseEntity.class, searchBox, g -> g != this && g.method_5805());
        for (GooseEntity goose : nearbyGeese) {
            goose.setRevengeTarget(killer);
        }
    }

    public void setRevengeTarget(class_1657 player) {
        this.revengeTargetUUID = player.method_5667();
        this.revengeTimer = 1200 + this.field_5974.method_43048(1200);
        long durationMs = 0x6DDD00L + (long)(this.field_5974.method_43058() * 4800000.0);
        this.revengeExpirationTime = System.currentTimeMillis() + durationMs;
    }

    public boolean hasRevengeTarget() {
        if (this.revengeTargetUUID == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return this.revengeExpirationTime <= 0L || currentTime < this.revengeExpirationTime;
    }

    public boolean isRevengeTimerReady() {
        return this.revengeTimer <= 0;
    }

    public void resetRevengeTimer() {
        this.revengeTimer = 1200 + this.field_5974.method_43048(1200);
    }

    @Nullable
    public class_1657 getRevengeTargetPlayer() {
        if (this.revengeTargetUUID == null) {
            return null;
        }
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return serverWorld.method_18470(this.revengeTargetUUID);
        }
        return null;
    }

    private void handleEggLaying() {
        if (this.method_6109()) {
            return;
        }
        if (this.eggLayTimer <= 0) {
            this.layEgg();
            this.eggLayTimer = 6000 + this.field_5974.method_43048(6000);
        } else {
            --this.eggLayTimer;
        }
    }

    private void layEgg() {
        class_1799 eggStack = this.getEggForVariant();
        if (!eggStack.method_7960()) {
            class_1542 eggEntity = new class_1542(this.method_73183(), this.method_23317(), this.method_23318(), this.method_23321(), eggStack);
            eggEntity.method_18800(0.0, 0.05, 0.0);
            this.method_73183().method_8649((class_1297)eggEntity);
            this.method_5783(class_3417.field_15219, 0.5f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    private class_1799 getEggForVariant() {
        class_6880<GooseVariant> variant = this.getVariant();
        if (variant.method_40225(GooseVariants.TEMPERATE)) {
            return new class_1799((class_1935)SillyGooseItems.WHITE_EGG);
        }
        if (variant.method_40225(GooseVariants.COLD)) {
            return new class_1799((class_1935)SillyGooseItems.BIG_WHITE_EGG);
        }
        if (variant.method_40225(GooseVariants.WARM)) {
            return new class_1799((class_1935)SillyGooseItems.SMALL_WHITE_EGG);
        }
        return new class_1799((class_1935)SillyGooseItems.WHITE_EGG);
    }

    public static boolean canSpawn(class_1299<GooseEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (!class_1429.method_20663(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random)) {
            return false;
        }
        return GooseEntity.hasWaterNearby(world, pos, 12, 5);
    }

    private static boolean hasWaterNearby(class_5425 world, class_2338 center, int horizontalRadius, int verticalRange) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int waterBlocksFound = 0;
        int requiredWaterBlocks = 6;
        for (int x = -horizontalRadius; x <= horizontalRadius; x += 2) {
            for (int z = -horizontalRadius; z <= horizontalRadius; z += 2) {
                for (int y = -verticalRange; y <= verticalRange; ++y) {
                    class_2338 below;
                    mutable.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                    if (!(world.method_8316((class_2338)mutable).method_15767(class_3486.field_15517) ? ++waterBlocksFound >= requiredWaterBlocks : world.method_8320((class_2338)mutable).method_26164(class_3481.field_15467) && world.method_8316(below = mutable.method_10074()).method_15767(class_3486.field_15517) && ++waterBlocksFound >= requiredWaterBlocks)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected class_3414 method_6002() {
        return SillyGooseSounds.GOOSE_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SillyGooseSounds.GOOSE_HURT;
    }

    protected class_3414 method_5994() {
        return SillyGooseSounds.GOOSE_HONK;
    }

    private void handlePreferenceChange() {
        if (this.method_6109()) {
            return;
        }
        if (this.preferenceChangeTimer <= 0) {
            if (this.field_5974.method_43057() < 0.75f) {
                this.setPrefersWater(!this.getPrefersWater());
            }
            this.preferenceChangeTimer = 4800 + this.field_5974.method_43048(2400);
        } else {
            --this.preferenceChangeTimer;
        }
    }

    private void handleOffPreferenceTimer() {
        boolean inOffPreferenceZone;
        boolean prefersWater = this.getPrefersWater();
        boolean inWater = this.method_5799();
        boolean bl = inOffPreferenceZone = prefersWater && !inWater || !prefersWater && inWater;
        if (inOffPreferenceZone) {
            if (!this.isInOffPreferenceMode) {
                this.isInOffPreferenceMode = true;
                this.offPreferenceTimer = 600 + this.field_5974.method_43048(600);
            } else {
                --this.offPreferenceTimer;
            }
        } else {
            this.isInOffPreferenceMode = false;
            this.offPreferenceTimer = 0;
        }
    }

    public boolean shouldReturnToPreference() {
        return this.isInOffPreferenceMode && this.offPreferenceTimer <= 0;
    }

    private void handleWaterFloating() {
        boolean isSwimming;
        boolean hasAirAbove;
        if (!this.method_5799() || this.method_5765()) {
            return;
        }
        class_2338 pos = this.method_24515();
        double entityHeight = this.method_6109() ? 0.9624999999999999 : 1.375;
        int topBlockOffset = (int)Math.ceil(entityHeight);
        class_2338 airCheckPos = pos.method_10086(topBlockOffset);
        boolean bl = hasAirAbove = !this.method_73183().method_8316(airCheckPos).method_15767(class_3486.field_15517) && this.method_73183().method_8320(airCheckPos).method_26215();
        if (!hasAirAbove) {
            class_243 velocity = this.method_18798();
            double surfaceBoost = this.method_6109() ? 0.12 : 0.1;
            this.method_18800(velocity.field_1352, surfaceBoost, velocity.field_1350);
            this.field_6037 = true;
            return;
        }
        double waterSurfaceY = (double)pos.method_10264() + 1.0;
        class_2338 checkPos = new class_2338((int)this.method_23317(), (int)waterSurfaceY, (int)this.method_23321());
        while (this.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) {
            checkPos = new class_2338((int)this.method_23317(), (int)(waterSurfaceY += 1.0), (int)this.method_23321());
        }
        float floatOffset = this.method_6109() ? 0.234375f : 0.34375f;
        double targetY = waterSurfaceY - (double)floatOffset;
        double currentY = this.method_23318();
        double yDiff = targetY - currentY;
        class_243 velocity = this.method_18798();
        boolean bl2 = isSwimming = Math.abs(velocity.field_1352) > 0.02 || Math.abs(velocity.field_1350) > 0.02;
        if (isSwimming) {
            class_2338[] checkPositions;
            boolean nearLand = false;
            for (class_2338 landCheck : checkPositions = new class_2338[]{pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
                if (!this.method_73183().method_8316(landCheck).method_15767(class_3486.field_15517) && this.method_73183().method_8320(landCheck).method_51367()) {
                    nearLand = true;
                    break;
                }
                class_2338 upOne = landCheck.method_10084();
                if (this.method_73183().method_8316(upOne).method_15767(class_3486.field_15517) || !this.method_73183().method_8320(upOne).method_51367()) continue;
                nearLand = true;
                break;
            }
            if (nearLand) {
                double boostStrength = this.method_6109() ? 0.15 : 0.14;
                this.method_18800(velocity.field_1352, Math.max(velocity.field_1351, boostStrength), velocity.field_1350);
                this.field_6037 = true;
                return;
            }
        }
        if (!this.method_24828() && Math.abs(yDiff) < 2.0) {
            double newYVelocity = yDiff > 0.1 ? Math.min(0.08, yDiff * 0.1) : (yDiff < -0.1 ? Math.max(-0.03, yDiff * 0.1) : velocity.field_1351 * 0.5);
            if (isSwimming) {
                newYVelocity = velocity.field_1351 * 0.8 + newYVelocity * 0.2;
            }
            this.method_18800(velocity.field_1352, newYVelocity, velocity.field_1350);
            this.field_6037 = true;
        }
    }

    private void setupAnimationStates() {
        boolean isRunning;
        boolean inWater = this.method_5799();
        boolean isMovingHorizontally = this.method_18798().method_37268() > 0.001;
        boolean isInHitAndRun = this.isInHitAndRunMode();
        boolean bl = isRunning = isMovingHorizontally && isInHitAndRun;
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 2;
            class_7094 targetAnimation = null;
            targetAnimation = inWater ? (isRunning ? this.swimFastAnimationState : (isMovingHorizontally ? this.swimAnimationState : this.idleWaterAnimationState)) : (isRunning ? this.runAnimationState : (isMovingHorizontally ? this.walkAnimationState : (isInHitAndRun ? this.wingsUpIdleAnimationState : this.idleAnimationState)));
            if (targetAnimation != null && !targetAnimation.method_41327()) {
                this.idleAnimationState.method_41325();
                this.idleWaterAnimationState.method_41325();
                this.walkAnimationState.method_41325();
                this.runAnimationState.method_41325();
                this.swimAnimationState.method_41325();
                this.swimFastAnimationState.method_41325();
                this.wingsUpIdleAnimationState.method_41325();
                targetAnimation.method_41322(this.field_6012);
            }
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public boolean isInHitAndRunMode() {
        return (Boolean)this.field_6011.method_12789(IS_IN_HIT_AND_RUN_MODE);
    }

    public void setInHitAndRunMode(boolean inMode) {
        this.field_6011.method_12778(IS_IN_HIT_AND_RUN_MODE, (Object)inMode);
    }

    public boolean method_5939(class_1799 stack) {
        if (this.method_6109()) {
            return false;
        }
        class_1304 equipmentSlot = this.method_32326(stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 && stack.method_31573(class_3489.field_42611) && this.method_5936();
    }

    public boolean method_5936() {
        return (Boolean)this.field_6011.method_12789(CAN_PICKUP_LOOT);
    }

    public void method_5952(boolean canPickUpLoot) {
        this.field_6011.method_12778(CAN_PICKUP_LOOT, (Object)canPickUpLoot);
    }

    protected void method_5949(class_3218 world, class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        if (this.method_5939(stack)) {
            this.method_29499(itemEntity);
            this.method_5673(class_1304.field_6173, stack.method_7971(1));
            this.method_5946(class_1304.field_6173, 2.0f);
            this.method_6103((class_1297)itemEntity, stack.method_7947());
            if (stack.method_7960()) {
                itemEntity.method_31472();
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_31573(class_3489.field_49943) && !this.method_6118(class_1304.field_6173).method_7960() && this.method_6118(class_1304.field_6173).method_31573(class_3489.field_42611)) {
            if (!this.method_73183().method_8608()) {
                class_1799 sword = this.method_6118(class_1304.field_6173).method_7972();
                class_1542 itemEntity = new class_1542(this.method_73183(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), sword);
                this.method_73183().method_8649((class_1297)itemEntity);
                this.method_5673(class_1304.field_6173, class_1799.field_8037);
                this.method_5952(false);
                this.swordPickupCooldownTimer = 400;
                if (!player.method_31549().field_7477) {
                    stackInHand.method_7934(1);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    UnfairTradeAdvancementHandler.grantUnfairTradeAdvancement(serverPlayer);
                }
                this.method_5783((class_3414)class_3417.field_20614.comp_349(), 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private void handleSwordPickupCooldown() {
        if (this.swordPickupCooldownTimer > 0) {
            --this.swordPickupCooldownTimer;
            if (this.swordPickupCooldownTimer <= 0) {
                this.method_5952(true);
            }
        }
    }

    @Nullable
    public GooseEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        GooseEntity gooseEntity = (GooseEntity)SillyGooseEntities.GOOSE.method_5883((class_1937)serverWorld, class_3730.field_16466);
        if (gooseEntity != null && passiveEntity instanceof GooseEntity) {
            GooseEntity gooseEntity2 = (GooseEntity)passiveEntity;
            gooseEntity.setVariant(this.field_5974.method_43056() ? this.getVariant() : gooseEntity2.getVariant());
            gooseEntity.setPrefersWater(this.getPrefersWater());
        }
        return gooseEntity;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        GooseGroupData groupData;
        if (spawnReason != class_3730.field_16461 && spawnReason != class_3730.field_16466 && spawnReason != class_3730.field_16462) {
            class_10704.method_71969((class_10701)class_10701.method_67169((class_5425)world, (class_2338)this.method_24515()), SillyGooseRegistryKeys.GOOSE_VARIANT).ifPresent(this::setVariant);
        }
        if (!this.method_6109()) {
            this.preferenceChangeTimer = 4800 + this.field_5974.method_43048(2400);
            this.method_5952(this.field_5974.method_43057() < 1.0f);
            this.eggLayTimer = 6000 + this.field_5974.method_43048(6000);
            if (spawnReason == class_3730.field_16459 && this.field_5974.method_43057() < 0.3f) {
                entityData = new GooseGroupData(true);
            }
        }
        if (entityData instanceof GooseGroupData && (groupData = (GooseGroupData)entityData).shouldSpawnBabies()) {
            int babyCount = 1 + this.field_5974.method_43048(3);
            for (int i = 0; i < babyCount; ++i) {
                GooseEntity baby = (GooseEntity)SillyGooseEntities.GOOSE.method_5883((class_1937)world.method_8410(), class_3730.field_16459);
                if (baby == null) continue;
                baby.method_7217(true);
                baby.setVariant(this.getVariant());
                baby.setPrefersWater(this.getPrefersWater());
                double offsetX = this.field_5974.method_43059() * 0.5;
                double offsetZ = this.field_5974.method_43059() * 0.5;
                baby.method_5808(this.method_23317() + offsetX, this.method_23318(), this.method_23321() + offsetZ, this.field_5974.method_43057() * 360.0f, 0.0f);
                world.method_8649((class_1297)baby);
            }
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5619() {
        super.method_5619();
        if (this.preferenceChangeTimer == 0) {
            this.preferenceChangeTimer = 4800 + this.field_5974.method_43048(2400);
        }
        if (this.eggLayTimer == 0) {
            this.eggLayTimer = 6000 + this.field_5974.method_43048(6000);
        }
    }

    public void setVariant(class_6880<GooseVariant> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    public class_6880<GooseVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public boolean getPrefersWater() {
        return (Boolean)this.field_6011.method_12789(PREFERS_WATER);
    }

    public void setPrefersWater(boolean prefersWater) {
        this.field_6011.method_12778(PREFERS_WATER, (Object)prefersWater);
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == SillyGooseDataComponentTypes.GOOSE_VARIANT ? GooseEntity.method_66651(type, (Object)new class_9791(this.getVariant())) : super.method_58694(type));
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, SillyGooseDataComponentTypes.GOOSE_VARIANT);
        super.method_66649(from);
    }

    public float method_17825() {
        return this.method_6109() ? 0.7f : 1.0f;
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == SillyGooseDataComponentTypes.GOOSE_VARIANT) {
            class_9791 lazyRef = (class_9791)GooseEntity.method_66651(SillyGooseDataComponentTypes.GOOSE_VARIANT, value);
            lazyRef.method_60739((class_7225.class_7874)this.method_56673()).ifPresent(this::setVariant);
            return true;
        }
        return super.method_66654(type, value);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(class_3489.field_49943);
    }

    public static class GooseGroupData
    implements class_1315 {
        private final boolean shouldSpawnBabies;

        public GooseGroupData(boolean shouldSpawnBabies) {
            this.shouldSpawnBabies = shouldSpawnBabies;
        }

        public boolean shouldSpawnBabies() {
            return this.shouldSpawnBabies;
        }
    }
}

